/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.security.random.DefaultSecureRandomService;
import com.atlassian.security.random.SecureRandomService;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;

public class AccessTokenGenerator {
    private static final char DELIMITER = ':';
    private static final int ID_LENGTH = 12;
    private static final int SECRET_LENGTH = 20;
    private static final int TOKEN_LENGTH = 33;
    private final PasswordEncoder passwordEncoder = DefaultPasswordEncoder.getDefaultInstance();
    private final SecureRandomService secureRandomService = DefaultSecureRandomService.getInstance();

    public boolean authenticateToken(@NotNull String token, @NotNull String hashedToken) {
        String secret = this.getSecret(token);
        return this.passwordEncoder.isValidPassword(secret, hashedToken);
    }

    @NotNull
    public String generateToken() {
        byte[] tokenBytes = new byte[33];
        byte[] id = this.generateId();
        System.arraycopy(id, 0, tokenBytes, 0, id.length);
        tokenBytes[id.length] = 58;
        byte[] secret = this.generateSecret();
        System.arraycopy(secret, 0, tokenBytes, id.length + 1, secret.length);
        return Base64.encodeBase64String((byte[])tokenBytes);
    }

    @NotNull
    public String getId(@NotNull String token) throws IllegalArgumentException {
        if (!this.isValidToken(token)) {
            throw new IllegalArgumentException("The provided token is not a valid access token");
        }
        return new String(Arrays.copyOfRange(Base64.decodeBase64((String)token), 0, 12), StandardCharsets.UTF_8);
    }

    @NotNull
    public String hashToken(@NotNull String token) {
        if (!this.isValidToken(token)) {
            throw new IllegalArgumentException("The provided token is not a valid access token");
        }
        String secret = this.getSecret(token);
        return this.passwordEncoder.encodePassword(secret);
    }

    public boolean isValidToken(@NotNull String token) {
        byte[] decodedToken;
        return Base64.isArrayByteBase64((byte[])token.getBytes(StandardCharsets.UTF_8)) && (decodedToken = Base64.decodeBase64((String)token)).length == 33 && decodedToken[12] == 58;
    }

    private byte[] generateId() {
        StringBuilder idBuilder = new StringBuilder(12);
        for (int i = 0; i < 12; ++i) {
            idBuilder.append(this.secureRandomService.nextInt(10));
        }
        return idBuilder.toString().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] generateSecret() {
        byte[] secret = new byte[20];
        this.secureRandomService.nextBytes(secret);
        return secret;
    }

    private String getSecret(@NotNull String token) {
        byte[] decodedToken = Base64.decodeBase64((String)token);
        byte[] secret = Arrays.copyOfRange(decodedToken, 13, decodedToken.length);
        return Base64.encodeBase64String((byte[])secret);
    }
}

