/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AbstractAccessTokenNotification;
import com.atlassian.bamboo.accesstoken.AccessTokenCreatedNotification;
import com.atlassian.bamboo.accesstoken.AccessTokenDeletedNotification;
import com.atlassian.bamboo.accesstoken.event.AbstractAccessTokenEvent;
import com.atlassian.bamboo.accesstoken.event.AccessTokenCreatedEvent;
import com.atlassian.bamboo.accesstoken.event.AccessTokenDeletedEvent;
import com.atlassian.bamboo.notification.Notification;
import com.atlassian.bamboo.notification.NotificationDispatcher;
import com.atlassian.bamboo.notification.NotificationFactory;
import com.atlassian.bamboo.notification.NotificationRecipient;
import com.atlassian.bamboo.utils.BambooNotificationUtils;
import com.atlassian.event.api.EventListener;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class AccessTokenListener {
    private static final Logger log = Logger.getLogger(AccessTokenListener.class);
    @Inject
    private NotificationFactory notificationFactory;
    @Inject
    private NotificationDispatcher notificationDispatcher;

    @EventListener
    public void accessTokenCreated(AccessTokenCreatedEvent event) {
        log.debug((Object)("New access token created event: " + event));
        this.dispatchNotification((AbstractAccessTokenEvent)event, AccessTokenCreatedNotification.class);
    }

    @EventListener
    public void accessTokenRevoked(AccessTokenDeletedEvent event) {
        log.debug((Object)("Access token revoked event: " + event));
        this.dispatchNotification((AbstractAccessTokenEvent)event, AccessTokenDeletedNotification.class);
    }

    private void dispatchNotification(AbstractAccessTokenEvent event, Class<? extends AbstractAccessTokenNotification> notificationClass) {
        AbstractAccessTokenNotification notification = BambooNotificationUtils.createNotification(notificationClass);
        notification.setEvent(event);
        notification.addRecipient((NotificationRecipient)this.notificationFactory.getUserRecipient(event.getAccessToken().getUserName()));
        this.notificationDispatcher.dispatchNotifications((Notification)notification);
    }
}

