/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class AccessTokenServiceUtils {
    public static void validateRequestedPermissionsDependencies(@NotNull Set<AccessTokenPermission> requestPermissions) {
        Map missingDependencies = AccessTokenServiceUtils.getMissingDependencies(requestPermissions).asMap();
        if (!missingDependencies.isEmpty()) {
            StringJoiner joiner = new StringJoiner(",");
            for (Map.Entry entry : missingDependencies.entrySet()) {
                String missingPermissionsNames = ((Collection)entry.getValue()).stream().map(Enum::name).collect(Collectors.joining(", "));
                joiner.add(String.format("[%s] for %s", missingPermissionsNames, entry.getKey()));
            }
            throw new IllegalArgumentException("When granting permissions to token following dependant permissions must also be granted: " + joiner.toString());
        }
    }

    @VisibleForTesting
    static SetMultimap<AccessTokenPermission, AccessTokenPermission> getMissingDependencies(@NotNull Set<AccessTokenPermission> requestPermissions) {
        HashMultimap missingDependencies = HashMultimap.create();
        for (AccessTokenPermission permission : requestPermissions) {
            Set<AccessTokenPermission> effectiveDependencies = AccessTokenServiceUtils.getEffectiveDependencies(permission);
            for (AccessTokenPermission permissionDependency : effectiveDependencies) {
                if (requestPermissions.contains(permissionDependency)) continue;
                missingDependencies.put((Object)permission, (Object)permissionDependency);
            }
        }
        return missingDependencies;
    }

    private static Set<AccessTokenPermission> getEffectiveDependencies(@NotNull AccessTokenPermission permission) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)permission.getDependencies());
        permission.getDependencies().stream().peek(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0)).map(AccessTokenServiceUtils::getEffectiveDependencies).forEach(arg_0 -> ((ImmutableSet.Builder)builder).addAll(arg_0));
        return builder.build();
    }
}

