/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessTokenAnalyticsService;
import com.atlassian.bamboo.accesstoken.AccessTokenDao;
import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;

class DefaultAccessTokenAnalyticsService
implements AccessTokenAnalyticsService {
    private final AccessTokenDao accessTokenDao;
    private final AtomicLong basicAuthenticationCount = new AtomicLong(0L);
    private final AtomicLong tokenAuthenticationCount = new AtomicLong(0L);

    public DefaultAccessTokenAnalyticsService(AccessTokenDao accessTokenDao) {
        this.accessTokenDao = accessTokenDao;
    }

    @Override
    public void incrementBasicAuthenticationCount() {
        this.basicAuthenticationCount.incrementAndGet();
    }

    @Override
    public void incrementTokenAuthenticationCount() {
        this.tokenAuthenticationCount.incrementAndGet();
    }

    @Override
    public long getAndResetBasicAuthenticationCount() {
        return this.basicAuthenticationCount.getAndSet(0L);
    }

    @Override
    public long getAndResetTokenAuthenticationCount() {
        return this.tokenAuthenticationCount.getAndSet(0L);
    }

    @Override
    public long countTokensWithPermission(@NotNull AccessTokenPermission accessTokenPermission) {
        return this.accessTokenDao.countTokensWithPermission(accessTokenPermission);
    }
}

