/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import com.atlassian.bamboo.accesstoken.MutableAccessToken;
import com.atlassian.bamboo.accesstoken.SimpleAccessToken;
import com.atlassian.bamboo.hibernate.HibernateEntityObject;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="ACCESS_TOKEN", indexes={@Index(name="USER_NAME_IDX", columnList="USER_NAME"), @Index(name="PERMISSIONS_MASK_IDX", columnList="PERMISSIONS_MASK")}, uniqueConstraints={@UniqueConstraint(columnNames={"USER_NAME", "NAME"})})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="ACCESS_TOKEN_ID"))
public class MutableAccessTokenImpl
extends HibernateEntityObject
implements MutableAccessToken {
    @Column(name="HASHED_TOKEN", nullable=false)
    private String hashedToken;
    @Column(name="TOKEN_ID", nullable=false, unique=true)
    private String tokenId;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="USER_NAME", nullable=false)
    private String userName;
    @Column(name="CREATED_DATE", nullable=false)
    private Date creationDate;
    @Column(name="PERMISSIONS_MASK", nullable=false)
    @ColumnDefault(value="0")
    private int permissionsMask;

    @NotNull
    public String getHashedToken() {
        return this.hashedToken;
    }

    public void setHashedToken(@NotNull String hashedToken) {
        this.hashedToken = hashedToken;
    }

    @NotNull
    public String getTokenId() {
        return this.tokenId;
    }

    public void setTokenId(@NotNull String tokenId) {
        this.tokenId = tokenId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @NotNull
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(@NotNull String userName) {
        this.userName = userName;
    }

    @NotNull
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setPermissions(@NotNull Iterable<AccessTokenPermission> permissions) {
        this.permissionsMask = 0;
        for (AccessTokenPermission permission : permissions) {
            this.permissionsMask |= permission.getMask();
        }
    }

    @NotNull
    public Set<AccessTokenPermission> getPermissions() {
        return Arrays.stream(AccessTokenPermission.values()).filter(permission -> (this.permissionsMask & permission.getMask()) != 0).collect(Collectors.toSet());
    }

    public int getPermissionsMask() {
        return this.permissionsMask;
    }

    public void setPermissionsMask(int permissionsMask) {
        this.permissionsMask = permissionsMask;
    }

    public AccessToken toAccessToken() {
        return new SimpleAccessToken(this.getCreationDate(), this.tokenId, this.name, this.userName, this.getPermissions());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MutableAccessTokenImpl that = (MutableAccessTokenImpl)((Object)o);
        return Objects.equals(this.tokenId, that.tokenId);
    }

    public int hashCode() {
        return Objects.hash(this.tokenId);
    }
}

