/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.accesstoken;

import com.atlassian.bamboo.accesstoken.AccessToken;
import com.atlassian.bamboo.accesstoken.AccessTokenPermission;
import com.google.common.collect.ImmutableSet;
import java.util.Date;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jetbrains.annotations.NotNull;

@Immutable
class SimpleAccessToken
implements AccessToken {
    private final Date creationDate;
    private final String tokenId;
    private final String name;
    private final String userName;
    private final Set<AccessTokenPermission> permissions;

    public SimpleAccessToken(@NotNull Date creationDate, @NotNull String tokenId, @NotNull String name, @NotNull String userName, @NotNull Iterable<AccessTokenPermission> permissions) {
        this.creationDate = new Date(creationDate.getTime());
        this.tokenId = tokenId;
        this.name = name;
        this.userName = userName;
        this.permissions = ImmutableSet.copyOf(permissions);
    }

    @NotNull
    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    @NotNull
    public String getTokenId() {
        return this.tokenId;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getUserName() {
        return this.userName;
    }

    @NotNull
    public Set<AccessTokenPermission> getPermissions() {
        return this.permissions;
    }

    public final AccessToken toAccessToken() {
        return new SimpleAccessToken(new Date(this.creationDate.getTime()), this.tokenId, this.name, this.userName, this.permissions);
    }
}

