/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.admin.configuration;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.admin.configuration.AdministrationConfigurationService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.AdministrationConfigurationPersister;
import com.atlassian.bamboo.configuration.ConcurrentBuildConfig;
import com.atlassian.bamboo.configuration.external.polling.RepositoryStoredSpecsPollingScheduler;
import com.atlassian.bamboo.event.SecuritySettingsUpdatedEvent;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.plan.branch.BranchDetectionJobScheduler;
import com.atlassian.bamboo.plan.pullrequest.PullRequestDetectionJobScheduler;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.setup.BootstrapManager;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.event.api.EventPublisher;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.net.URISyntaxException;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.Nullable;
import org.quartz.SchedulerException;

public class AdministrationConfigurationServiceImpl
implements AdministrationConfigurationService {
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final AdministrationConfigurationPersister administrationConfigurationPersister;
    private final BranchDetectionJobScheduler branchDetectionJobScheduler;
    private final BootstrapManager bootstrapManager;
    private final BambooPermissionManager bambooPermissionManager;
    private final FeatureManager featureManager;
    private final PullRequestDetectionJobScheduler pullRequestDetectionJobScheduler;
    private final RepositoryStoredSpecsPollingScheduler repositoryStoredSpecsPollingScheduler;
    private final EventPublisher eventPublisher;

    public AdministrationConfigurationServiceImpl(AdministrationConfigurationAccessor administrationConfigurationAccessor, AdministrationConfigurationPersister administrationConfigurationPersister, BranchDetectionJobScheduler branchDetectionJobScheduler, FeatureManager featureManager, BootstrapManager bootstrapManager, BambooPermissionManager bambooPermissionManager, PullRequestDetectionJobScheduler pullRequestDetectionJobScheduler, RepositoryStoredSpecsPollingScheduler repositoryStoredSpecsPollingScheduler, EventPublisher eventPublisher) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.administrationConfigurationPersister = administrationConfigurationPersister;
        this.branchDetectionJobScheduler = branchDetectionJobScheduler;
        this.featureManager = featureManager;
        this.bootstrapManager = bootstrapManager;
        this.bambooPermissionManager = bambooPermissionManager;
        this.pullRequestDetectionJobScheduler = pullRequestDetectionJobScheduler;
        this.repositoryStoredSpecsPollingScheduler = repositoryStoredSpecsPollingScheduler;
        this.eventPublisher = eventPublisher;
    }

    public void updateAdministrationConfiguration(AdministrationConfiguration administrationConfiguration) throws WebValidationException, SchedulerException {
        if (!this.hasRestrictedAdministrationPermission()) {
            throw new AccessDeniedException("No restricted administration permission, cannot update administration configuration");
        }
        AdministrationConfiguration currentAdministrationConfiguration = this.getAdministrationConfiguration();
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        if (currentAdministrationConfiguration.getBranchDetectionCheckInterval() != administrationConfiguration.getBranchDetectionCheckInterval()) {
            this.branchDetectionJobScheduler.rescheduleBranchDetecting();
            this.pullRequestDetectionJobScheduler.reschedulePullRequestDetecting();
        }
        if (!currentAdministrationConfiguration.getRssDetectionConfiguration().equals((Object)administrationConfiguration.getRssDetectionConfiguration())) {
            this.repositoryStoredSpecsPollingScheduler.rescheduleRssPolling();
        }
        this.eventPublisher.publish((Object)new SecuritySettingsUpdatedEvent(administrationConfiguration, this));
    }

    public ConcurrentBuildConfig updateBuildConcurrency(@Nullable Boolean isEnabled, @Nullable Integer numberOfConcurrentBuilds) throws WebValidationException {
        if (!this.hasRestrictedAdministrationPermission()) {
            throw new UnauthorisedException("No restricted administration permission, cannot update administration configuration");
        }
        AdministrationConfiguration administrationConfiguration = this.getAdministrationConfiguration();
        ConcurrentBuildConfig currentConfig = administrationConfiguration.getConcurrentBuildConfig();
        if (numberOfConcurrentBuilds != null) {
            BambooValidationUtils.validate(numberOfConcurrentBuilds > 0, "Number of concurrent build must greater than 0");
            currentConfig.setNumberConcurrentBuilds(numberOfConcurrentBuilds.intValue());
        }
        if (isEnabled != null) {
            currentConfig.setEnabled(isEnabled.booleanValue());
        }
        this.administrationConfigurationPersister.saveAdministrationConfiguration(administrationConfiguration);
        return administrationConfiguration.getConcurrentBuildConfig();
    }

    @VisibleForTesting
    protected boolean hasRestrictedAdministrationPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.RESTRICTEDADMINISTRATION);
    }

    public AdministrationConfiguration getAdministrationConfiguration() {
        if (!this.hasRestrictedAdministrationPermission()) {
            throw new AccessDeniedException("No restricted administration permission, cannot retrieve administration configuration");
        }
        return this.administrationConfigurationAccessor.getAdministrationConfiguration();
    }

    public void setBrokerURI(String brokerUri) throws URISyntaxException {
        this.bootstrapManager.setBrokerURI(new URI(brokerUri));
    }

    public String getBrokerURI() throws URISyntaxException {
        return this.bootstrapManager.getBrokerURI().toString();
    }

    public String getBrokerClientURI() throws URISyntaxException {
        return this.bootstrapManager.getBrokerClientURI().toString();
    }

    public void setBrokerClientURI(String brokerClientUri) throws URISyntaxException {
        this.bootstrapManager.setBrokerClientURI(new URI(brokerClientUri));
    }
}

