/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.admin.configuration;

import com.atlassian.bamboo.admin.configuration.GeneralConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import org.apache.commons.lang3.StringUtils;

public class GeneralConfigurationImpl
implements GeneralConfiguration {
    private String instanceName;
    private String baseUrl;
    private String gravatarServerUrl;
    private String brokerURI;
    private String brokerClientURI;
    private Integer dashboardDefaultPageSize;
    private Integer branchDetectionIntervalSeconds;
    private Boolean gravatarSupportEnabled;
    private Boolean gzipCompressionEnabled;
    private Boolean rssPollingEnabled;
    private String rssPollingCronExpression;

    public GeneralConfigurationImpl(AdministrationConfiguration administrationConfiguration, String brokerURI, String brokerClientURI) {
        this.instanceName = administrationConfiguration.getInstanceName();
        this.baseUrl = administrationConfiguration.getBaseUrl();
        this.gravatarSupportEnabled = administrationConfiguration.isGravatarSupportEnabled();
        this.gzipCompressionEnabled = administrationConfiguration.isUseGzipCompression();
        if (this.gravatarSupportEnabled.booleanValue()) {
            this.gravatarServerUrl = StringUtils.isBlank((CharSequence)administrationConfiguration.getGravatarServerUrl()) ? "https://secure.gravatar.com/avatar/" : administrationConfiguration.getGravatarServerUrl();
        }
        this.branchDetectionIntervalSeconds = administrationConfiguration.getBranchDetectionCheckInterval();
        this.dashboardDefaultPageSize = administrationConfiguration.getDashboardPageSize();
        this.brokerURI = brokerURI;
        this.brokerClientURI = brokerClientURI;
        this.rssPollingEnabled = administrationConfiguration.getRssDetectionConfiguration().isPollingEnabled();
        this.rssPollingCronExpression = administrationConfiguration.getRssDetectionConfiguration().getPollingCronExpression();
    }

    public GeneralConfigurationImpl(String instanceName, String baseUrl, String gravatarServerUrl, String brokerURI, String brokerClientURI, Integer dashboardDefaultPageSize, Integer branchDetectionIntervalSeconds, Boolean gravatarSupportEnabled, Boolean gzipCompressionEnabled, Boolean rssPollingEnabled, String rssPollingCronExpression) {
        this.instanceName = instanceName;
        this.baseUrl = baseUrl;
        this.gravatarServerUrl = gravatarServerUrl;
        this.brokerURI = brokerURI;
        this.brokerClientURI = brokerClientURI;
        this.dashboardDefaultPageSize = dashboardDefaultPageSize;
        this.branchDetectionIntervalSeconds = branchDetectionIntervalSeconds;
        this.gravatarSupportEnabled = gravatarSupportEnabled;
        this.gzipCompressionEnabled = gzipCompressionEnabled;
        this.rssPollingEnabled = rssPollingEnabled;
        this.rssPollingCronExpression = rssPollingCronExpression;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setGravatarServerUrl(String gravatarServerUrl) {
        this.gravatarServerUrl = gravatarServerUrl;
    }

    public void setBrokerURI(String brokerURI) {
        this.brokerURI = brokerURI;
    }

    public void setBrokerClientURI(String brokerClientURI) {
        this.brokerClientURI = brokerClientURI;
    }

    public void setDashboardDefaultPageSize(Integer dashboardDefaultPageSize) {
        this.dashboardDefaultPageSize = dashboardDefaultPageSize;
    }

    public void setBranchDetectionIntervalSeconds(Integer branchDetectionIntervalSeconds) {
        this.branchDetectionIntervalSeconds = branchDetectionIntervalSeconds;
    }

    public void setGravatarSupportEnabled(Boolean enableGravatarSupport) {
        this.gravatarSupportEnabled = enableGravatarSupport;
    }

    public void setGzipCompressionEnabled(Boolean enableGzipCompression) {
        this.gzipCompressionEnabled = enableGzipCompression;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getGravatarServerUrl() {
        return this.gravatarServerUrl;
    }

    public String getBrokerURI() {
        return this.brokerURI;
    }

    public String getBrokerClientURI() {
        return this.brokerClientURI;
    }

    public Integer getDashboardDefaultPageSize() {
        return this.dashboardDefaultPageSize;
    }

    public Integer getBranchDetectionIntervalSeconds() {
        return this.branchDetectionIntervalSeconds;
    }

    public Boolean isGravatarSupportEnabled() {
        return this.gravatarSupportEnabled;
    }

    public Boolean isGzipCompressionEnabled() {
        return this.gzipCompressionEnabled;
    }

    public Boolean isRssPollingEnabled() {
        return this.rssPollingEnabled;
    }

    public void setRssPollingEnabled(Boolean rssPollingEnabled) {
        this.rssPollingEnabled = rssPollingEnabled;
    }

    public String getRssPollingCronExpression() {
        return this.rssPollingCronExpression;
    }

    public void setRssPollingCronExpression(String rssPollingCronExpression) {
        this.rssPollingCronExpression = rssPollingCronExpression;
    }
}

