/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.admin.configuration;

import com.atlassian.bamboo.admin.configuration.AdministrationConfigurationService;
import com.atlassian.bamboo.admin.configuration.GeneralConfiguration;
import com.atlassian.bamboo.admin.configuration.GeneralConfigurationImpl;
import com.atlassian.bamboo.admin.configuration.GeneralConfigurationService;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.RssDetectionConfiguration;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.user.gravatar.GravatarService;
import com.atlassian.bamboo.utils.BambooValidationUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.struts.TextProvider;
import com.google.common.base.MoreObjects;
import com.opensymphony.util.TextUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronExpression;
import org.quartz.SchedulerException;

public class GeneralConfigurationServiceImpl
implements GeneralConfigurationService {
    @Inject
    private AdministrationConfigurationService administrationConfigurationService;
    @Inject
    private GravatarService gravatarService;
    @Inject
    private TextProvider textProvider;
    private static final Logger logger = Logger.getLogger(GeneralConfigurationServiceImpl.class);

    public GeneralConfiguration getGeneralConfiguration() throws URISyntaxException {
        String brokerUri = this.administrationConfigurationService.getBrokerURI();
        String brokerClientUri = this.administrationConfigurationService.getBrokerClientURI();
        AdministrationConfiguration adminConfig = this.administrationConfigurationService.getAdministrationConfiguration();
        return new GeneralConfigurationImpl(adminConfig, brokerUri, brokerClientUri);
    }

    public GeneralConfiguration updateGeneralConfiguration(@Nullable String instanceName, @Nullable String baseUrl, @Nullable String gravatarServerUrl, @Nullable String brokerUrl, @Nullable String brokerClientUrl, @Nullable Integer dashboardDefaultSize, @Nullable Integer branchDetectionIntervalSeconds, @Nullable Boolean gravatarSupportEnabled, @Nullable Boolean gzipCompressionEnabled, @Nullable Boolean enableRssPolling, @Nullable String rssPollingCronExpression) throws WebValidationException, URISyntaxException {
        GeneralConfiguration generalConfiguration = this.getGeneralConfiguration();
        generalConfiguration.setInstanceName((String)MoreObjects.firstNonNull((Object)instanceName, (Object)generalConfiguration.getInstanceName()));
        generalConfiguration.setBaseUrl((String)MoreObjects.firstNonNull((Object)baseUrl, (Object)generalConfiguration.getBaseUrl()));
        generalConfiguration.setGravatarServerUrl((String)MoreObjects.firstNonNull((Object)gravatarServerUrl, (Object)generalConfiguration.getGravatarServerUrl()));
        generalConfiguration.setBrokerURI((String)MoreObjects.firstNonNull((Object)brokerUrl, (Object)generalConfiguration.getBrokerURI()));
        generalConfiguration.setBrokerClientURI((String)MoreObjects.firstNonNull((Object)brokerClientUrl, (Object)generalConfiguration.getBrokerClientURI()));
        generalConfiguration.setDashboardDefaultPageSize((Integer)MoreObjects.firstNonNull((Object)dashboardDefaultSize, (Object)generalConfiguration.getDashboardDefaultPageSize()));
        generalConfiguration.setBranchDetectionIntervalSeconds((Integer)MoreObjects.firstNonNull((Object)branchDetectionIntervalSeconds, (Object)generalConfiguration.getBranchDetectionIntervalSeconds()));
        generalConfiguration.setGravatarSupportEnabled((Boolean)MoreObjects.firstNonNull((Object)gravatarSupportEnabled, (Object)generalConfiguration.isGravatarSupportEnabled()));
        generalConfiguration.setGzipCompressionEnabled((Boolean)MoreObjects.firstNonNull((Object)gzipCompressionEnabled, (Object)generalConfiguration.isGzipCompressionEnabled()));
        generalConfiguration.setRssPollingEnabled((Boolean)MoreObjects.firstNonNull((Object)enableRssPolling, (Object)generalConfiguration.isRssPollingEnabled()));
        generalConfiguration.setRssPollingCronExpression((String)MoreObjects.firstNonNull((Object)rssPollingCronExpression, (Object)generalConfiguration.getRssPollingCronExpression()));
        if (!generalConfiguration.getBrokerURI().equals(brokerUrl)) {
            logger.info((Object)"Broker URL has been updated - please restart your Bamboo application to apply the change.");
        }
        if (!generalConfiguration.getBrokerClientURI().equals(brokerClientUrl)) {
            logger.info((Object)"Broker client URL has been updated - please restart all your Agents to apply the change.");
        }
        return this.updateGeneralConfiguration(generalConfiguration);
    }

    private GeneralConfiguration updateGeneralConfiguration(GeneralConfiguration input) throws WebValidationException, URISyntaxException {
        BambooValidationUtils.checkErrors(this.validateConfiguration(input));
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationService.getAdministrationConfiguration();
        administrationConfiguration.setInstanceName(input.getInstanceName());
        administrationConfiguration.setBaseUrl(input.getBaseUrl());
        administrationConfiguration.setDashboardPageSize(input.getDashboardDefaultPageSize().intValue());
        administrationConfiguration.setBranchDetectionCheckInterval(input.getBranchDetectionIntervalSeconds().intValue());
        administrationConfiguration.setUseGzipCompression(input.isGzipCompressionEnabled().booleanValue());
        administrationConfiguration.setGravatarSupportEnabled(input.isGravatarSupportEnabled().booleanValue());
        administrationConfiguration.setGravatarServerUrl(input.getGravatarServerUrl());
        administrationConfiguration.setRssDetectionConfiguration(new RssDetectionConfiguration(input.isRssPollingEnabled().booleanValue(), input.getRssPollingCronExpression()));
        try {
            this.administrationConfigurationService.updateAdministrationConfiguration(administrationConfiguration);
            this.administrationConfigurationService.setBrokerURI(input.getBrokerURI());
            this.administrationConfigurationService.setBrokerClientURI(input.getBrokerClientURI());
        }
        catch (SchedulerException e) {
            throw new WebValidationException("branch detection interval", "Scheduler exception thrown while attempting to update the branch detection interval");
        }
        catch (URISyntaxException e) {
            throw new WebValidationException("broker uri / broker client uri", "Invalid broker uri or broker client uri");
        }
        if (StringUtils.isNotBlank((CharSequence)input.getGravatarServerUrl())) {
            this.gravatarService.setGravatarSupported(input.isGravatarSupportEnabled().booleanValue(), input.getGravatarServerUrl());
        }
        return this.getGeneralConfiguration();
    }

    private ErrorCollection validateConfiguration(GeneralConfiguration config) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        this.validate((ErrorCollection)errors, TextUtils.verifyUrl((String)config.getBaseUrl()), "Base Url", this.textProvider.getText("config.server.baseUrl.error.invalid"));
        this.validate((ErrorCollection)errors, config.getDashboardDefaultPageSize() > 0, "Dashboard Default Page Size", this.textProvider.getText("config.server.dashboardPageSize.error.invalid"));
        this.validate((ErrorCollection)errors, config.getBranchDetectionIntervalSeconds() > 0, "Branch Detection Interval", this.textProvider.getText("config.server.branchDetectionInterval.error.invalid"));
        this.validate((ErrorCollection)errors, this.validURI(config.getBrokerURI()), "Broker Url", this.textProvider.getText("config.options.brokerUrl.error.invalid"));
        this.validate((ErrorCollection)errors, this.validURI(config.getBrokerClientURI()), "Broker Client Url", this.textProvider.getText("config.options.brokerClientUrl.error.invalid"));
        if (config.isGravatarSupportEnabled().booleanValue()) {
            this.validate((ErrorCollection)errors, StringUtils.isNotBlank((CharSequence)config.getGravatarServerUrl()), "Gravatar Server Url", this.textProvider.getText("config.server.gravatarUrlField.error.invalid"));
        }
        if (config.isRssPollingEnabled().booleanValue()) {
            if (StringUtils.isEmpty((CharSequence)config.getRssPollingCronExpression())) {
                errors.addError("Rss polling cron expression", this.textProvider.getText("repository.change.schedule.cronExpression.error.required"));
            } else {
                try {
                    CronExpression cronExpr = new CronExpression(config.getRssPollingCronExpression());
                    cronExpr.getNextValidTimeAfter(new Date());
                }
                catch (ParseException e) {
                    errors.addError("Rss polling cron expression", this.textProvider.getText("repository.change.schedule.cronExpression.error.invalid"));
                }
                catch (UnsupportedOperationException e) {
                    errors.addError("Rss polling cron expression", this.textProvider.getText("repository.change.schedule.cronExpression.error.unsupported"));
                }
                catch (Exception e) {
                    errors.addError("Rss polling cron expression", this.textProvider.getText("repository.change.schedule.cronExpression.error.failure"));
                }
            }
        }
        return errors;
    }

    private void validate(ErrorCollection errors, boolean validationCondition, String field, String message) {
        if (!validationCondition) {
            errors.addError(field, message);
        }
    }

    private boolean validURI(String input) {
        try {
            URI throwaway = new URI(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

