/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.admin.configuration;

import com.atlassian.bamboo.admin.configuration.MailConfigurationService;
import com.atlassian.bamboo.crypto.instance.SecretEncryptionService;
import com.atlassian.bamboo.exception.NotFoundException;
import com.atlassian.bamboo.exception.UnauthorisedException;
import com.atlassian.bamboo.exception.WebValidationException;
import com.atlassian.bamboo.mail.SMTPMailServerWithEncryptedPassword;
import com.atlassian.bamboo.notification.EmailValidator;
import com.atlassian.bamboo.notification.PortValidator;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.EncryptionException;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.MailProtocol;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.struts.TextProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.acegisecurity.acls.Permission;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class MailConfigurationServiceImpl
implements MailConfigurationService {
    private static final Logger log = Logger.getLogger(MailConfigurationServiceImpl.class);
    private static final String ALLOWED_JNDI_PREFIX = "java:";
    private final SecretEncryptionService secretEncryptionService;
    private final BambooPermissionManager bambooPermissionManager;
    private final TextProvider textProvider;
    static MailServerManager mailServerManager = null;

    @Inject
    public MailConfigurationServiceImpl(@Lazy SecretEncryptionService secretEncryptionService, BambooPermissionManager bambooPermissionManager, TextProvider textProvider) {
        this.secretEncryptionService = secretEncryptionService;
        this.bambooPermissionManager = bambooPermissionManager;
        this.textProvider = textProvider;
    }

    public boolean isMailServerConfigured() throws UnauthorisedException {
        this.requireSystemAdministrator();
        return this.currentMailServer() != null;
    }

    @NotNull
    public SMTPMailServer getMailServer() throws UnauthorisedException, NotFoundException {
        this.requireSystemAdministrator();
        SMTPMailServer currentMailServer = this.currentMailServer();
        if (currentMailServer != null) {
            return currentMailServer;
        }
        throw new NotFoundException(this.textProvider.getText("config.email.server.notfound.error"));
    }

    @NotNull
    public SMTPMailServer updateMailServer(@Nullable String name, @Nullable String fromAddress, @Nullable String subjectPrefix, @Nullable Boolean precedenceBulkHeaderExcluded, @Nullable String emailSetting, @Nullable String smtpServer, @Nullable String smtpPort, @Nullable String smtpUsername, @Nullable String smtpPassword, @Nullable Boolean tlsEnabled, @Nullable String jndiLocation) throws WebValidationException, UnauthorisedException {
        return this.updateMailServer(name, fromAddress, subjectPrefix, precedenceBulkHeaderExcluded, (MailConfigurationService.MailMode)Optional.ofNullable(emailSetting).map(MailConfigurationService.MailMode::valueOf).orElse(null), smtpServer, smtpPort, smtpUsername, smtpPassword, tlsEnabled, jndiLocation);
    }

    @NotNull
    public SMTPMailServer updateMailServer(@Nullable String name, @Nullable String fromAddress, @Nullable String subjectPrefix, @Nullable Boolean precedenceBulkHeaderExcluded, @Nullable MailConfigurationService.MailMode emailSetting, @Nullable String smtpServer, @Nullable String smtpPort, @Nullable String smtpUsername, @Nullable String smtpPassword, @Nullable Boolean tlsEnabled, @Nullable String jndiLocation) throws WebValidationException, UnauthorisedException {
        this.requireSystemAdministrator();
        Boolean newServer = false;
        Object currentMailServer = this.currentMailServer();
        if (currentMailServer == null) {
            currentMailServer = new SMTPMailServerWithEncryptedPassword();
            newServer = true;
        }
        this.validate((SMTPMailServer)currentMailServer, name, fromAddress, subjectPrefix, precedenceBulkHeaderExcluded, emailSetting, smtpServer, smtpPort, smtpUsername, smtpPassword, tlsEnabled, jndiLocation);
        currentMailServer.setName((String)ObjectUtils.firstNonNull((Object[])new String[]{name, currentMailServer.getName()}));
        currentMailServer.setDefaultFrom((String)ObjectUtils.firstNonNull((Object[])new String[]{fromAddress, currentMailServer.getDefaultFrom()}));
        currentMailServer.setPrefix((String)ObjectUtils.firstNonNull((Object[])new String[]{subjectPrefix, currentMailServer.getPrefix()}));
        currentMailServer.setRemovePrecedence(((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{precedenceBulkHeaderExcluded, currentMailServer.isRemovePrecedence()})).booleanValue());
        currentMailServer.setJndiLocation(jndiLocation);
        if (currentMailServer.getJndiLocation() != null) {
            currentMailServer.setSessionServer(true);
            currentMailServer.setPort(null);
            currentMailServer.setHostname(null);
            currentMailServer.setUsername(null);
            currentMailServer.setPassword(null);
            currentMailServer.setTlsRequired(false);
        } else {
            currentMailServer.setSessionServer(false);
            currentMailServer.setMailProtocol(MailProtocol.SMTP);
            currentMailServer.setHostname((String)ObjectUtils.firstNonNull((Object[])new String[]{smtpServer, currentMailServer.getHostname()}));
            currentMailServer.setPort((String)ObjectUtils.firstNonNull((Object[])new String[]{smtpPort, currentMailServer.getPort()}));
            currentMailServer.setUsername((String)ObjectUtils.firstNonNull((Object[])new String[]{smtpUsername, currentMailServer.getUsername()}));
            currentMailServer.setPassword(this.encrypt(smtpPassword, currentMailServer.getPassword()));
            currentMailServer.setTlsRequired(((Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{tlsEnabled, currentMailServer.isTlsRequired()})).booleanValue());
        }
        try {
            if (newServer.booleanValue()) {
                this.getMailServerManager().create((MailServer)currentMailServer);
            }
            this.getMailServerManager().update((MailServer)currentMailServer);
        }
        catch (MailException e) {
            throw new WebValidationException(this.textProvider.getText("config.email.server.update.error", Arrays.asList(e.getMessage())));
        }
        return currentMailServer;
    }

    @Nullable
    private String encrypt(@Nullable String newValue, @Nullable String oldValue) {
        String value = Optional.ofNullable(newValue).orElseGet(() -> this.tryDecrypt(oldValue));
        return Optional.ofNullable(value).map(arg_0 -> ((SecretEncryptionService)this.secretEncryptionService).encrypt(arg_0)).orElse(null);
    }

    @Nullable
    private String tryDecrypt(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.secretEncryptionService.decrypt(value);
        }
        catch (EncryptionException e) {
            log.debug(null, (Throwable)e);
            return value;
        }
    }

    public void deleteMailServer() throws NotFoundException, MailException {
        this.requireSystemAdministrator();
        SMTPMailServer currentMailServer = this.currentMailServer();
        if (currentMailServer == null) {
            throw new NotFoundException(this.textProvider.getText("config.email.server.notfound.error"));
        }
        this.deleteMailServer(currentMailServer);
    }

    private void requireSystemAdministrator() throws UnauthorisedException {
        if (!this.hasAdministrationPermission()) {
            throw new UnauthorisedException(this.textProvider.getText("config.email.server.unauthorised.error"));
        }
    }

    private MailServerManager getMailServerManager() {
        if (mailServerManager != null) {
            return mailServerManager;
        }
        mailServerManager = MailFactory.getServerManager();
        return mailServerManager;
    }

    private SMTPMailServer currentMailServer() {
        return this.getMailServerManager().getDefaultSMTPMailServer();
    }

    private void deleteMailServer(SMTPMailServer toDelete) throws MailException, UnauthorisedException {
        this.getMailServerManager().delete(toDelete.getId());
    }

    private void validate(@NotNull SMTPMailServer currentMailServer, @Nullable String name, @Nullable String fromAddress, @Nullable String subjectPrefix, @Nullable Boolean precedenceBulkHeaderExcluded, @Nullable MailConfigurationService.MailMode emailSetting, @Nullable String smtpServer, @Nullable String smtpPort, @Nullable String smtpUsername, @Nullable String smtpPassword, @Nullable Boolean tlsEnabled, @Nullable String jndiLocation) throws WebValidationException {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (StringUtils.isBlank((CharSequence)((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{name, currentMailServer.getName()})))) {
            errors.addError("name", this.textProvider.getText("config.email.server.name.error"));
        }
        if (StringUtils.isBlank((CharSequence)((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{fromAddress, currentMailServer.getDefaultFrom()})))) {
            errors.addError("from", this.textProvider.getText("config.email.from.error"));
        } else if (!EmailValidator.isValidEmailAddressFormat((String)ObjectUtils.firstNonNull((Object[])new String[]{fromAddress, currentMailServer.getDefaultFrom()}))) {
            errors.addError("from", this.textProvider.getText("user.email.error.invalid"));
        }
        MailConfigurationService.MailMode currentMailMode = null;
        if (emailSetting == null) {
            if (currentMailServer.getHostname() != null || currentMailServer.getJndiLocation() != null) {
                currentMailMode = currentMailServer.getJndiLocation() != null ? MailConfigurationService.MailMode.JNDI : MailConfigurationService.MailMode.SMTP;
            }
        } else if (emailSetting == MailConfigurationService.MailMode.JNDI) {
            currentMailMode = MailConfigurationService.MailMode.JNDI;
        } else if (emailSetting == MailConfigurationService.MailMode.SMTP) {
            currentMailMode = MailConfigurationService.MailMode.SMTP;
        }
        if (currentMailMode == MailConfigurationService.MailMode.JNDI) {
            String updatedJndiLocation = (String)ObjectUtils.firstNonNull((Object[])new String[]{jndiLocation, currentMailServer.getJndiLocation()});
            if (StringUtils.isBlank((CharSequence)updatedJndiLocation)) {
                errors.addError("jndi location", this.textProvider.getText("config.email.error.requiredJndi"));
            } else {
                List<String> errorMessages = this.validateJndiLocation(updatedJndiLocation);
                errorMessages.forEach(arg_0 -> MailConfigurationServiceImpl.lambda$validate$1((ErrorCollection)errors, arg_0));
            }
            if (smtpServer != null) {
                errors.addError("host", this.textProvider.getText("config.email.jndi.invalid.setting"));
            }
            if (smtpPort != null) {
                errors.addError("port", this.textProvider.getText("config.email.jndi.invalid.setting"));
            }
            if (smtpUsername != null) {
                errors.addError("username", this.textProvider.getText("config.email.jndi.invalid.setting"));
            }
            if (smtpPassword != null) {
                errors.addError("password", this.textProvider.getText("config.email.jndi.invalid.setting"));
            }
            if (tlsEnabled != null && tlsEnabled.booleanValue()) {
                errors.addError("tls required", this.textProvider.getText("config.email.jndi.invalid.setting"));
            }
        } else if (currentMailMode == MailConfigurationService.MailMode.SMTP) {
            if (StringUtils.isBlank((CharSequence)((CharSequence)ObjectUtils.firstNonNull((Object[])new String[]{smtpServer, currentMailServer.getHostname()})))) {
                errors.addError("smtp host", this.textProvider.getText("config.email.error.requiredHost"));
            }
            if (!PortValidator.isValidPortNumber((String)ObjectUtils.firstNonNull((Object[])new String[]{smtpPort, currentMailServer.getPort()}))) {
                errors.addError("smtp port", this.textProvider.getText("config.email.smtp.port.error"));
            }
            if (jndiLocation != null) {
                errors.addError("jndi location", this.textProvider.getText("config.email.smtp.invalid.setting"));
            }
        } else {
            errors.addError("email settings", this.textProvider.getText("config.email.emailSettings.description"));
        }
        if (errors.hasAnyErrors()) {
            throw new WebValidationException((ErrorCollection)errors);
        }
    }

    private boolean hasAdministrationPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
    }

    @NotNull
    public List<String> validateJndiLocation(@NotNull String jndiName) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!StringUtils.startsWith((CharSequence)jndiName, (CharSequence)ALLOWED_JNDI_PREFIX)) {
            validationErrors.add(this.textProvider.getText("config.email.error.invalidJndi"));
        }
        return validationErrors;
    }

    private static /* synthetic */ void lambda$validate$1(ErrorCollection errors, String errorMessage) {
        errors.addError("jndi location", errorMessage);
    }
}

