/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.admin.scheduler;

import com.atlassian.bamboo.admin.scheduler.ScheduledJob;
import com.atlassian.bamboo.admin.scheduler.SchedulerService;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.acls.Permission;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.matchers.GroupMatcher;

public class SchedulerServiceImpl
implements SchedulerService {
    private final BambooPermissionManager bambooPermissionManager;
    private final Scheduler scheduler;

    public SchedulerServiceImpl(@NotNull BambooPermissionManager bambooPermissionManager, @NotNull Scheduler scheduler) {
        this.bambooPermissionManager = bambooPermissionManager;
        this.scheduler = scheduler;
    }

    @NotNull
    public List<ScheduledJob> getJobs() throws SchedulerException {
        if (!this.hasGlobalAdministratorPermission()) {
            throw new AccessDeniedException("The current user does not have the administrator permission.");
        }
        ArrayList<ScheduledJob> jobs = new ArrayList<ScheduledJob>();
        List groupNames = this.scheduler.getJobGroupNames();
        for (String groupName : groupNames) {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName));
            for (JobKey jobKey : jobKeys) {
                List jobTriggers = this.scheduler.getTriggersOfJob(jobKey);
                Date nextScheduledTime = jobTriggers.stream().findFirst().map(Trigger::getNextFireTime).orElse(null);
                jobs.add(new ScheduledJob(jobKey, nextScheduledTime));
            }
        }
        return jobs;
    }

    public void triggerJob(@NotNull ScheduledJob job) throws SchedulerException {
        if (!this.hasGlobalAdministratorPermission()) {
            throw new AccessDeniedException("The current user does not have the administrator permission.");
        }
        this.scheduler.triggerJob(job.getJobKey());
    }

    private boolean hasGlobalAdministratorPermission() {
        return this.bambooPermissionManager.hasGlobalPermission((Permission)BambooPermission.ADMINISTRATION);
    }
}

