/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent;

import com.atlassian.bamboo.agent.AgentSecurityTokenService;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;

public class AgentSecurityTokenServiceImpl
implements AgentSecurityTokenService {
    private static final BandanaContext BANDANA_CONTEXT = PlanAwareBandanaContext.GLOBAL_CONTEXT;
    private static final String BANDANA_KEY = "remoteAgentsSecurityToken";
    private static final SecureTokenGenerator SECURE_TOKEN_GENERATOR = DefaultSecureTokenGenerator.getInstance();
    @Inject
    private BandanaManager bandanaManager;

    @NotNull
    public String getSecurityToken() {
        String securityToken = (String)this.bandanaManager.getValue(BANDANA_CONTEXT, BANDANA_KEY);
        Preconditions.checkState((securityToken != null ? 1 : 0) != 0, (Object)"Security token has not been set for this Bamboo instance");
        return securityToken;
    }

    public void resetSecurityToken() {
        this.bandanaManager.setValue(BANDANA_CONTEXT, BANDANA_KEY, (Object)SECURE_TOKEN_GENERATOR.generateToken());
    }
}

