/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.AgentClassServer;
import com.atlassian.bamboo.agent.classserver.ClassServerManifest;
import com.atlassian.bamboo.agent.classserver.ClassServerManifestImpl;
import com.atlassian.bamboo.agent.classserver.ClasspathDiscoverer;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.io.FileInputSupplier;
import com.atlassian.bamboo.io.PluginArtifactInputSupplier;
import com.atlassian.bamboo.plugin.AgentPluginResolver;
import com.atlassian.bamboo.plugin.osgi.FrameworkBundlesResolver;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.InputSupplier;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.context.ServletContextAware;

public class AgentClassServerImpl
implements AgentClassServer,
ServletContextAware {
    private static final Map<File, Pair<Long, JarDescriptor>> JAR_DESCRIPTOR_CACHE = new ConcurrentHashMap<File, Pair<Long, JarDescriptor>>();
    private static final Function<Plugin, JarDescriptor> PLUGIN_TO_JAR_DESCRIPTOR = plugin -> {
        PluginArtifact pluginArtifact = plugin.getPluginArtifact();
        if (pluginArtifact == null) {
            return null;
        }
        File file = pluginArtifact.toFile();
        Pair<Long, JarDescriptor> jarDescriptorWithTimestamp = JAR_DESCRIPTOR_CACHE.get(file);
        if (jarDescriptorWithTimestamp != null && ((Long)jarDescriptorWithTimestamp.getLeft()).equals(file.lastModified())) {
            return (JarDescriptor)jarDescriptorWithTimestamp.getRight();
        }
        JarDescriptor jarDescriptor = new JarDescriptor(pluginArtifact.toFile(), pluginArtifact.getName(), (InputSupplier)new PluginArtifactInputSupplier(pluginArtifact));
        JAR_DESCRIPTOR_CACHE.putIfAbsent(file, (Pair<Long, JarDescriptor>)Pair.of((Object)file.lastModified(), (Object)jarDescriptor));
        return (JarDescriptor)JAR_DESCRIPTOR_CACHE.get(file).getRight();
    };
    private ServletContext servletContext;
    private final ResettableLazyReference<Map<String, JarDescriptor>> systemClasspath = new ResettableLazyReference<Map<String, JarDescriptor>>(){

        protected Map<String, JarDescriptor> create() throws Exception {
            Preconditions.checkState((AgentClassServerImpl.this.servletContext != null ? 1 : 0) != 0, (Object)"ServletContext was not set");
            return AgentClassServerImpl.this.classpathDiscoverer.discoverClasspath(AgentClassServerImpl.this.servletContext);
        }
    };
    private final Supplier<List<JarDescriptor>> pluginFrameworkBundles = new ResettableLazyReference<List<JarDescriptor>>(){

        protected List<JarDescriptor> create() throws Exception {
            return AgentClassServerImpl.this.frameworkBundlesResolver.getFrameworkBundles();
        }
    };
    private final ResettableLazyReference<InputSupplier<InputStream>> classPathZipResettableLazyReference = new ResettableLazyReference<InputSupplier<InputStream>>(){

        protected InputSupplier<InputStream> create() throws Exception {
            return new FileInputSupplier(AgentClassServerImpl.this.classPathFileSupplier());
        }
    };
    private final AgentPluginResolver agentPluginResolver;
    private final ClasspathDiscoverer classpathDiscoverer;
    private final FrameworkBundlesResolver frameworkBundlesResolver;

    public AgentClassServerImpl(AgentPluginResolver agentPluginResolver, ClasspathDiscoverer classpathDiscoverer, FrameworkBundlesResolver frameworkBundlesResolver) {
        this.agentPluginResolver = agentPluginResolver;
        this.classpathDiscoverer = classpathDiscoverer;
        this.frameworkBundlesResolver = frameworkBundlesResolver;
    }

    @NotNull
    public ClassServerManifest getSystemClasspath() {
        return new ClassServerManifestImpl(Collections.emptySet(), Sets.newHashSet(this.getJarsOnSystemClasspath().values()));
    }

    @NotNull
    public Map<String, JarDescriptor> getJarsOnSystemClasspath() {
        if (SystemProperty.BAMBOO_RELOAD_AGENT_CLASSPATH.getValue(false)) {
            this.systemClasspath.reset();
        }
        return (Map)this.systemClasspath.get();
    }

    @NotNull
    public Map<String, JarDescriptor> getJarsOfUserInstalledPlugins() {
        Iterable jars = BambooIterables.stream(this.getPluginsAvailableForRemoteAgents()).map(PLUGIN_TO_JAR_DESCRIPTOR).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        return Maps.uniqueIndex((Iterable)jars, JarDescriptor::getName);
    }

    @NotNull
    public Map<String, JarDescriptor> getJarsOfSystemProvidedPlugins() {
        Iterable<Plugin> systemProvidedPlugins = this.agentPluginResolver.getAgentPlugins(AgentPluginResolver.AgentPluginFilter.newFilter().setAvailableOnly().setSystemProvidedOnly());
        Iterable jars = BambooIterables.stream(systemProvidedPlugins).map(PLUGIN_TO_JAR_DESCRIPTOR).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
        return Maps.uniqueIndex((Iterable)jars, JarDescriptor::getName);
    }

    @NotNull
    public Map<String, JarDescriptor> getJarsOfFrameworkBundle() {
        return Maps.uniqueIndex(new HashSet(this.pluginFrameworkBundles.get()), JarDescriptor::getName);
    }

    @NotNull
    public ClassServerManifest getSystemClasspath(@NotNull Set<FileHashDescriptor> fileHashDescriptorsFromAgent) {
        Set bambooServerJars = this.getSystemClasspath().getJars();
        return this.calculateDifference(fileHashDescriptorsFromAgent, (Map<String, JarDescriptor>)Maps.uniqueIndex((Iterable)bambooServerJars, JarDescriptor::getName));
    }

    @NotNull
    public ClassServerManifest getUserInstalledPlugins(@NotNull Set<FileHashDescriptor> fileHashDescriptors) {
        return this.calculateDifference(fileHashDescriptors, this.getJarsOfUserInstalledPlugins());
    }

    @NotNull
    public ClassServerManifest getSystemProvidedPlugins(@NotNull Set<FileHashDescriptor> fileHashDescriptors) {
        return this.calculateDifference(fileHashDescriptors, this.getJarsOfSystemProvidedPlugins());
    }

    public ClassServerManifest getPluginFrameworkBundles(@NotNull Set<FileHashDescriptor> fileHashDescriptors) {
        return this.calculateDifference(fileHashDescriptors, this.getJarsOfFrameworkBundle());
    }

    @NotNull
    public Iterable<Plugin> getPluginsAvailableForRemoteAgents() {
        return this.agentPluginResolver.getAgentPlugins(AgentPluginResolver.AgentPluginFilter.newFilter().setAvailableOnly().setUserInstalledOnly());
    }

    private Supplier<File> classPathFileSupplier() {
        return () -> {
            try {
                File file = BambooFileUtils.createSafeTempFile("classpath.zip", SystemDirectory.getCacheDirectory());
                try (FileOutputStream outputStream = new FileOutputStream(file);){
                    ClassServerManifest manifest = this.getSystemClasspath();
                    this.writeClasspathToOutputStream(manifest, outputStream);
                }
                return file;
            }
            catch (IOException e) {
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
        };
    }

    @NotNull
    public InputSupplier<InputStream> getSystemClasspathZip() {
        if (SystemProperty.BAMBOO_RELOAD_AGENT_CLASSPATH.getValue(false)) {
            this.classPathZipResettableLazyReference.reset();
        }
        return (InputSupplier)this.classPathZipResettableLazyReference.get();
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    private ClassServerManifest calculateDifference(Set<FileHashDescriptor> fileHashDescriptorsFromAgent, Map<String, JarDescriptor> serverJarDescriptorMap) {
        HashSet<FileHashDescriptor> jarsToRemove = new HashSet<FileHashDescriptor>();
        for (FileHashDescriptor fileHashDescriptorFromAgent : fileHashDescriptorsFromAgent) {
            String filename = this.filePathToName(fileHashDescriptorFromAgent.getFilename());
            JarDescriptor jarDescriptor = serverJarDescriptorMap.get(filename);
            if (jarDescriptor != null && jarDescriptor.getChecksum() == fileHashDescriptorFromAgent.getChecksum()) continue;
            jarsToRemove.add(fileHashDescriptorFromAgent);
        }
        Sets.SetView jarsToKeep = Sets.difference(fileHashDescriptorsFromAgent, jarsToRemove);
        Set jarNamesAlreadyOnAgentSide = jarsToKeep.stream().map(FileHashDescriptor::getFilename).map(this::filePathToName).collect(Collectors.toCollection(HashSet::new));
        Set jarsToAdd = serverJarDescriptorMap.values().stream().filter(serverJar -> !jarNamesAlreadyOnAgentSide.contains(serverJar.getFileHashDescriptor().getFilename())).collect(Collectors.toCollection(HashSet::new));
        return new ClassServerManifestImpl(jarsToRemove, jarsToAdd);
    }

    private String filePathToName(String filename) {
        int pathEnd = StringUtils.lastIndexOfAny((CharSequence)filename, (CharSequence[])new String[]{"/", "\\"});
        if (pathEnd > -1) {
            filename = filename.substring(pathEnd + 1);
        }
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClasspathToOutputStream(@NotNull ClassServerManifest classServerManifest, @NotNull OutputStream outputStream) throws IOException {
        CheckedOutputStream checksum = new CheckedOutputStream(outputStream, new Adler32());
        try (ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(checksum));){
            classServerManifest.write(os);
            for (JarDescriptor descriptor : classServerManifest.getJars()) {
                ZipEntry entry = new ZipEntry(descriptor.getName());
                os.putNextEntry(entry);
                try {
                    InputStream is = descriptor.getInputStream();
                    Throwable throwable = null;
                    try {
                        IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                finally {
                    os.closeEntry();
                }
            }
        }
    }
}

