/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.ClassServerManifest;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class ClassServerManifestImpl
implements ClassServerManifest {
    private static final Logger log = Logger.getLogger(ClassServerManifestImpl.class);
    private static final char TAB = '\t';
    private static final char REMOVE_START = '-';
    private static final char ADD_START = '+';
    private static final String MANIFEST_DAT = "MANIFEST.DAT";
    private final Set<FileHashDescriptor> jarsToRemove;
    private final Set<JarDescriptor> jarsToAdd;

    public ClassServerManifestImpl(Set<FileHashDescriptor> jarsToRemove, Set<JarDescriptor> jarsToAdd) {
        this.jarsToRemove = jarsToRemove;
        this.jarsToAdd = jarsToAdd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@NotNull ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry entry = new ZipEntry(MANIFEST_DAT);
        zipOutputStream.putNextEntry(entry);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(zipOutputStream));
        try {
            for (FileHashDescriptor fileHashDescriptor : this.jarsToRemove) {
                writer.append('-');
                writer.append('\t');
                writer.append(fileHashDescriptor.getFilename());
                writer.append('\t');
                writer.append(Long.toHexString(fileHashDescriptor.getChecksum()));
                writer.newLine();
            }
            for (JarDescriptor jarDescriptor : this.jarsToAdd) {
                writer.append('+');
                writer.append('\t');
                writer.append(jarDescriptor.getName());
                writer.append('\t');
                writer.append(Long.toHexString(jarDescriptor.getChecksum()));
                writer.newLine();
            }
        }
        finally {
            writer.flush();
            zipOutputStream.closeEntry();
        }
    }

    @NotNull
    public Set<FileHashDescriptor> getJarsToRemove() {
        return this.jarsToRemove;
    }

    @NotNull
    public Set<JarDescriptor> getJars() {
        return this.jarsToAdd;
    }
}

