/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.agent.classserver.ClasspathDiscoverer;
import com.atlassian.bamboo.agent.classserver.ClasspathJarUtils;
import com.atlassian.bamboo.agent.classserver.JarDescriptor;
import com.atlassian.bamboo.io.FileInputSupplier;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.SecureTemporaryFiles;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.util.AntPathMatcher;

public class ClasspathDiscovererImpl
implements ClasspathDiscoverer {
    private static final Logger log = Logger.getLogger(ClasspathDiscovererImpl.class);
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();
    private static final String ADDITIONAL_CONFIG_JAR = "bamboo-additional-config.jar";
    private static final String LOG4J_PROPERTIES = "log4j.properties";
    private static final String SERIALIZATION_WHITELIST = "serialization-whitelist.list";
    private static final List<String> ADDITIONAL_CONFIG_RESOURCES = ImmutableList.of((Object)"log4j.properties", (Object)"serialization-whitelist.list");
    private static final String[] BLACKLISTED_CLASSPATH_FILES = new String[]{"application-required-plugins.txt"};

    @Override
    public Map<String, JarDescriptor> discoverClasspath(@NotNull ServletContext servletContext) throws Exception {
        List<String> blackListPatterns = ClasspathJarUtils.getBlackListPatterns();
        URLClassLoader systemClassLoader = (URLClassLoader)this.getClass().getClassLoader();
        HashMap<String, JarDescriptor> descriptors = new HashMap<String, JarDescriptor>();
        String javaHome = SystemUtils.JAVA_HOME;
        for (URL url : systemClassLoader.getURLs()) {
            JarDescriptor jarFile;
            String name;
            String path = url.getPath();
            if (!url.getProtocol().equals("file")) {
                log.warn((Object)("Item found on server classpath '" + url + "' could not be referenced as a file. Not adding to classpath."));
                continue;
            }
            File file = new File(url.toURI());
            boolean isJreJar = path.startsWith(javaHome);
            if (!isJreJar && BuildUtils.isDevMode() && path.contains(File.separatorChar + "jre" + File.separatorChar + "lib" + File.separatorChar)) {
                log.error((Object)("Suspicious classpath entry (JRE jar not in JAVA_HOME): " + path + ", not including in classpath.zip"));
                isJreJar = true;
            }
            if (!isJreJar && path.endsWith(".jar") && file.isFile() && !this.isBlacklisted(blackListPatterns, name = file.getName())) {
                log.debug((Object)("Found jar '" + file.getAbsolutePath() + "' to add to classpath"));
                descriptors.putIfAbsent(name, new JarDescriptor(file, (InputSupplier)new FileInputSupplier(file)));
            }
            if (!file.getAbsolutePath().contains("target" + File.separator + "classes") || !file.isDirectory() || (jarFile = ClasspathDiscovererImpl.createJarFromClassPathDirectory(file)) == null || this.isBlacklisted(blackListPatterns, jarFile.getName())) continue;
            descriptors.putIfAbsent(jarFile.getName(), jarFile);
        }
        log.debug((Object)String.format("Adding a single jar '%s' to classpath with the following resources: %s", ADDITIONAL_CONFIG_JAR, Joiner.on((String)", ").join(ADDITIONAL_CONFIG_RESOURCES)));
        descriptors.putIfAbsent(ADDITIONAL_CONFIG_JAR, this.createJarFromResource(ADDITIONAL_CONFIG_RESOURCES, ADDITIONAL_CONFIG_JAR));
        String realPath = servletContext.getRealPath("/WEB-INF/lib");
        File path = new File(realPath);
        if (StringUtils.isNotEmpty((CharSequence)realPath) && path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (!file.isFile()) continue;
                String filename = file.getName();
                if (!this.isBlacklisted(blackListPatterns, filename)) {
                    log.debug((Object)("Found [" + filename + "], adding to classpath"));
                    descriptors.putIfAbsent(filename, new JarDescriptor(file, (InputSupplier)new FileInputSupplier(file)));
                    continue;
                }
                log.debug((Object)("Found blacklisted [" + filename + "]"));
            }
        }
        this.addProvidedJars(descriptors);
        return descriptors;
    }

    private void addProvidedJars(Map<String, JarDescriptor> descriptors) throws URISyntaxException {
        URL servletApiLocation = ServletContext.class.getProtectionDomain().getCodeSource().getLocation();
        File servletApiFile = new File(servletApiLocation.toURI());
        if (servletApiFile.canRead() && servletApiFile.isFile()) {
            String jarName = servletApiFile.getName();
            descriptors.putIfAbsent(jarName, new JarDescriptor(servletApiFile, (InputSupplier)new FileInputSupplier(servletApiFile)));
        }
    }

    @Nullable
    private static JarDescriptor createJarFromClassPathDirectory(File dir) throws IOException {
        String namePrefix = dir.getParentFile().getParentFile().getName() + "-dev";
        log.debug((Object)("Found classes directory '" + dir.getAbsolutePath() + "' to add to classpath as '" + namePrefix + "'"));
        File jar = BambooFileUtils.createSafeTempFile(namePrefix, ".jar");
        try {
            ClasspathJarUtils.createJar(jar, dir, new ClasspathJarUtils.JarBuilderWalker(Sets.newHashSet((Object[])BLACKLISTED_CLASSPATH_FILES)));
            return new JarDescriptor(jar, (InputSupplier)new FileInputSupplier(jar));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private boolean isBlacklisted(@NotNull List<String> blackListPatterns, @NotNull String fileName) {
        for (String pattern : blackListPatterns) {
            if (!ANT_PATH_MATCHER.match(pattern, fileName)) continue;
            return true;
        }
        return false;
    }

    private JarDescriptor createJarFromResource(@NotNull Iterable<String> resources, @NotNull String jarFileName) throws IOException {
        File file;
        try {
            file = SecureTemporaryFiles.create(SecureTemporaryFiles.builder().setPrefix("jarFromResource").setSuffix(".jar").build());
            FileOutputStream outputStream = new FileOutputStream(file);
            try (JarOutputStream jarOutputStream = new JarOutputStream(outputStream);){
                for (String resource : resources) {
                    URL resourceUrl = this.getClass().getResource('/' + resource);
                    Preconditions.checkState((resourceUrl != null ? 1 : 0) != 0, (String)"Could not find resource '%s' to package into '%s'", (Object[])new Object[]{resource, jarFileName});
                    jarOutputStream.putNextEntry(new ZipEntry(resource));
                    InputStream input = resourceUrl.openStream();
                    IOUtils.copy((InputStream)input, (OutputStream)jarOutputStream);
                    IOUtils.closeQuietly((InputStream)input);
                    jarOutputStream.closeEntry();
                }
            }
        }
        catch (IOException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        return new JarDescriptor(file, jarFileName, (InputSupplier)new FileInputSupplier(file));
    }
}

