/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.apache.commons.io.DirectoryWalker;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClasspathJarUtils {
    private static final Logger log = Logger.getLogger(ClasspathJarUtils.class);
    private static final String ZIP_FILE_SEPARATOR = "/";

    private ClasspathJarUtils() {
    }

    @Nullable
    public static File createJar(@NotNull File dir) throws IOException {
        return ClasspathJarUtils.createJar(dir, new JarBuilderWalker());
    }

    @Nullable
    public static File createJar(@NotNull File dir, @NotNull JarBuilderWalker jarBuilderWalker) throws IOException {
        File jarFile = File.createTempFile("bamboo", ".jar");
        jarFile.deleteOnExit();
        try {
            ClasspathJarUtils.createJar(jarFile, dir, jarBuilderWalker);
            return jarFile;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void createJar(@NotNull File outputJar, @NotNull File dir, @NotNull JarBuilderWalker jarBuilderWalker) throws IOException {
        Set<File> files = jarBuilderWalker.walk(dir);
        Preconditions.checkArgument((files.size() > 1 ? 1 : 0) != 0, (Object)"the supplied directory has to have the root directory + one file or directory");
        String rootPath = dir.getAbsolutePath();
        try (JarOutputStream os = new JarOutputStream(new FileOutputStream(outputJar));){
            for (File file : files) {
                String relativePath = file.getAbsolutePath().replace(rootPath, "").replace(File.separator, ZIP_FILE_SEPARATOR);
                if (!StringUtils.isNotEmpty((CharSequence)relativePath)) continue;
                relativePath = relativePath.substring(1, relativePath.length()) + (file.isDirectory() ? ZIP_FILE_SEPARATOR : "");
                JarEntry entry = new JarEntry(relativePath);
                os.putNextEntry(entry);
                if (!file.isFile()) continue;
                FileInputStream is = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)is).close();
                }
            }
            os.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> getBlackListPatterns() {
        List<String> list;
        URL url = Thread.currentThread().getContextClassLoader().getResource("com/atlassian/bamboo/agent/classserver/agent-bootstrap-blacklist.txt");
        if (url == null) {
            return Collections.emptyList();
        }
        InputStream inputStream = null;
        try {
            if (BuildUtils.isDevMode()) {
                try {
                    inputStream = new FileInputStream(new File(url.toURI()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                inputStream = url.openStream();
            }
            list = IOUtils.readLines(inputStream).stream().filter(TextPredicates.ignoreLineComment()).collect(Collectors.toList());
        }
        catch (IOException e) {
            List<String> list2;
            try {
                list2 = Collections.emptyList();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return list2;
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return list;
    }

    public static class JarBuilderWalker
    extends DirectoryWalker {
        private final Set<String> blacklist;

        private JarBuilderWalker() {
            this.blacklist = new HashSet<String>();
        }

        public JarBuilderWalker(Set<String> blacklist) {
            this.blacklist = blacklist;
        }

        public Set<File> walk(File baseDirectory) throws IOException {
            HashSet<File> files = new HashSet<File>();
            this.walk(baseDirectory, files);
            return files;
        }

        protected boolean handleDirectory(File directory, int depth, Collection results) throws IOException {
            results.add(directory);
            return true;
        }

        protected void handleFile(File file, int depth, Collection results) throws IOException {
            if (!this.isBlacklisted(file)) {
                results.add(file);
            }
        }

        private boolean isBlacklisted(File file) {
            return this.blacklist.contains(file.getName());
        }
    }
}

