/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ActiveInstanceAdjustmentType;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.core.BambooEntityObject;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Entity
@Table(name="ELASTIC_SCHEDULE")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class ElasticInstanceScheduleImpl
extends BambooEntityObject
implements ElasticInstanceSchedule {
    private String cronExpression;
    private ElasticImageConfiguration elasticImageConfiguration;
    private ActiveInstanceAdjustmentType activeInstanceAdjustmentType;
    private int targetActiveInstances;
    private boolean enabled = true;

    public ElasticInstanceScheduleImpl() {
    }

    public ElasticInstanceScheduleImpl(String cronExpression, ElasticImageConfiguration elasticImageConfiguration, ActiveInstanceAdjustmentType activeInstanceAdjustmentType, int targetActiveInstances) {
        this.cronExpression = cronExpression;
        this.elasticImageConfiguration = elasticImageConfiguration;
        this.activeInstanceAdjustmentType = activeInstanceAdjustmentType;
        this.targetActiveInstances = targetActiveInstances;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public ElasticImageConfiguration getElasticImageConfiguration() {
        return this.elasticImageConfiguration;
    }

    public void setElasticImageConfiguration(ElasticImageConfiguration elasticImageConfiguration) {
        this.elasticImageConfiguration = elasticImageConfiguration;
    }

    @NotNull
    public ActiveInstanceAdjustmentType getActiveInstanceAdjustmentType() {
        if (this.activeInstanceAdjustmentType != null) {
            return this.activeInstanceAdjustmentType;
        }
        return ActiveInstanceAdjustmentType.EQUALS;
    }

    public void setActiveInstanceAdjustmentType(ActiveInstanceAdjustmentType activeInstanceAdjustmentType) {
        this.activeInstanceAdjustmentType = activeInstanceAdjustmentType;
    }

    public int getTargetActiveInstances() {
        return this.targetActiveInstances;
    }

    public void setTargetActiveInstances(int targetActiveInstances) {
        this.targetActiveInstances = targetActiveInstances;
    }

    public int getNumberToAdjust(int currentInstances) {
        return this.getActiveInstanceAdjustmentType().getAdjustmentNumber(currentInstances, this.targetActiveInstances);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isRunOnStartup() {
        return StringUtils.isEmpty((CharSequence)this.cronExpression);
    }

    public boolean isAllElasticConfigurations() {
        return this.elasticImageConfiguration == null;
    }

    public int hashCode() {
        return new HashCodeBuilder(1327, 7).append(this.getId()).append((Object)this.cronExpression).append((Object)this.elasticImageConfiguration).append((Object)this.activeInstanceAdjustmentType).append(this.targetActiveInstances).append(this.enabled).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElasticInstanceScheduleImpl)) {
            return false;
        }
        ElasticInstanceScheduleImpl rhs = (ElasticInstanceScheduleImpl)((Object)o);
        return new EqualsBuilder().append(this.getId(), rhs.getId()).append((Object)this.cronExpression, (Object)rhs.cronExpression).append((Object)this.elasticImageConfiguration, (Object)rhs.elasticImageConfiguration).append((Object)this.activeInstanceAdjustmentType, (Object)rhs.activeInstanceAdjustmentType).append(this.targetActiveInstances, rhs.targetActiveInstances).append(this.enabled, rhs.enabled).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.getId()).append((Object)this.cronExpression).append((Object)this.elasticImageConfiguration).append((Object)this.activeInstanceAdjustmentType).append(this.targetActiveInstances).append(this.enabled).toString();
    }
}

