/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import javax.inject.Inject;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class ElasticInstanceScheduleJob
implements Job {
    @Inject
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    @Inject
    private ElasticInstanceScheduleManager elasticInstanceScheduleManager;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        long elasticInstanceScheduleId = jobExecutionContext.getMergedJobDataMap().getLong("elasticInstanceScheduleId");
        ElasticInstanceSchedule elasticInstanceSchedule = this.elasticInstanceScheduleManager.getElasticInstanceSchedule(elasticInstanceScheduleId);
        if (elasticInstanceSchedule != null) {
            try {
                this.elasticFunctionalityFacade.adjustElasticInstanceNumbers(elasticInstanceSchedule);
            }
            catch (AWSException e) {
                throw new JobExecutionException("Unable to adjust Elastic Agent Numbers for [" + elasticInstanceSchedule + ']', (Throwable)e, false);
            }
        }
    }
}

