/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleDao;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleImpl;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleManager;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleScheduler;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.persistence.HibernateLazyReferences;
import com.atlassian.core.bean.EntityObject;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ElasticInstanceScheduleManagerImpl
implements ElasticInstanceScheduleManager {
    private static final Logger log = Logger.getLogger(ElasticInstanceScheduleManagerImpl.class);
    private final ElasticInstanceScheduleDao elasticInstanceScheduleDao;
    private final ElasticInstanceScheduleScheduler elasticInstanceScheduleScheduler;

    public ElasticInstanceScheduleManagerImpl(ElasticInstanceScheduleDao elasticInstanceScheduleDao, ElasticInstanceScheduleScheduler elasticInstanceScheduleScheduler) {
        this.elasticInstanceScheduleDao = elasticInstanceScheduleDao;
        this.elasticInstanceScheduleScheduler = elasticInstanceScheduleScheduler;
    }

    @NotNull
    public List<ElasticInstanceSchedule> getElasticInstanceSchedules() {
        return this.elasticInstanceScheduleDao.findAll();
    }

    @NotNull
    public List<ElasticInstanceSchedule> getElasticInstanceSchedules(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        return this.elasticInstanceScheduleDao.findElasticInstanceScheduleByImageConfiguration(elasticImageConfiguration);
    }

    public ElasticInstanceSchedule getElasticInstanceSchedule(long elasticInstanceScheduleId) {
        ElasticInstanceSchedule elasticInstanceSchedule = (ElasticInstanceSchedule)this.elasticInstanceScheduleDao.findById(elasticInstanceScheduleId);
        HibernateLazyReferences.initialise(elasticInstanceSchedule);
        return elasticInstanceSchedule;
    }

    public void saveElasticInstanceSchedule(ElasticInstanceSchedule schedule) {
        this.elasticInstanceScheduleDao.save((EntityObject)schedule);
        if (schedule.isEnabled()) {
            this.elasticInstanceScheduleScheduler.scheduleElasticInstanceSchedule(schedule, true);
        } else {
            this.elasticInstanceScheduleScheduler.unscheduleElasticInstanceSchedule(schedule);
        }
    }

    public void removeElasticInstanceSchedule(@NotNull ElasticInstanceSchedule schedule) {
        this.elasticInstanceScheduleDao.remove(schedule);
        this.elasticInstanceScheduleScheduler.unscheduleElasticInstanceSchedule(schedule);
    }

    public void removeElasticInstanceSchedule(long elasticInstanceScheduleId) {
        ElasticInstanceScheduleImpl object = (ElasticInstanceScheduleImpl)this.elasticInstanceScheduleDao.findById(elasticInstanceScheduleId);
        if (object != null) {
            this.removeElasticInstanceSchedule(object);
        } else {
            log.warn((Object)("Unable to remove Elastic Schedule with id " + elasticInstanceScheduleId + " since it cannot be found"));
        }
    }
}

