/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleDao;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ElasticInstanceScheduleScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(ElasticInstanceScheduleScheduler.class);
    static final String ELASTIC_INSTANCE_SCHEDULE_ID = "elasticInstanceScheduleId";
    static final String JOB_GROUP = "ElasticInstanceSchedule";
    static final String JOB_NAME = "ElasticInstanceScheduleJob";
    private static final JobKey JOB_KEY = new JobKey("ElasticInstanceScheduleJob", "ElasticInstanceSchedule");
    static final String TRIGGER_PREFIX = "ElasticInstanceScheduleTrigger";
    private final Scheduler quartzScheduler;
    private final ElasticInstanceScheduleDao elasticInstanceScheduleDao;

    public ElasticInstanceScheduleScheduler(ElasticInstanceScheduleDao elasticInstanceScheduleDao, Scheduler quartzScheduler) {
        this.elasticInstanceScheduleDao = elasticInstanceScheduleDao;
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        try {
            JobDetail jobDetail = JobBuilder.newJob(ElasticInstanceScheduleJob.class).withIdentity(JOB_KEY).storeDurably().build();
            this.quartzScheduler.addJob(jobDetail, true);
            List schedules = this.elasticInstanceScheduleDao.findAll();
            for (ElasticInstanceSchedule schedule : schedules) {
                if (!schedule.isEnabled()) continue;
                if (schedule.isRunOnStartup()) {
                    JobDataMap jobDataMap = new JobDataMap();
                    jobDataMap.put(ELASTIC_INSTANCE_SCHEDULE_ID, schedule.getId());
                    this.quartzScheduler.triggerJob(JOB_KEY, jobDataMap);
                    continue;
                }
                this.scheduleElasticInstanceSchedule(schedule, false);
            }
        }
        catch (SchedulerException e) {
            log.warn((Object)"Unable to schedule ElasticInstanceSchedule. No scheduling will be occur for elastic agents", (Throwable)e);
        }
    }

    public void unscheduleElasticInstanceSchedule(ElasticInstanceSchedule schedule) {
        try {
            this.quartzScheduler.unscheduleJob(this.getTriggerKey(schedule));
        }
        catch (SchedulerException e) {
            log.warn((Object)("Unable to unschedule " + schedule), (Throwable)e);
        }
    }

    public void scheduleElasticInstanceSchedule(ElasticInstanceSchedule schedule, boolean updateSchedule) {
        if (schedule.isEnabled() && !schedule.isRunOnStartup()) {
            try {
                if (updateSchedule && this.getQuartzTrigger(schedule) != null) {
                    this.unscheduleElasticInstanceSchedule(schedule);
                }
                CronExpression cronExpression = new CronExpression(schedule.getCronExpression());
                Trigger trigger = TriggerBuilder.newTrigger().withIdentity(this.getTriggerKey(schedule)).forJob(new JobKey(JOB_NAME, JOB_GROUP)).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).startNow().build();
                trigger.getJobDataMap().put(ELASTIC_INSTANCE_SCHEDULE_ID, schedule.getId());
                this.quartzScheduler.scheduleJob(trigger);
                log.info((Object)("Scheduling cron agent: " + trigger.getKey() + " (" + cronExpression + "). Next fire: " + trigger.getNextFireTime()));
            }
            catch (ParseException | SchedulerException e) {
                log.warn((Object)("Unable to schedule id '" + schedule.getId() + "' with cron expression: " + schedule.getCronExpression()), e);
            }
        } else if (!schedule.isEnabled()) {
            this.unscheduleElasticInstanceSchedule(schedule);
        }
    }

    public Trigger getQuartzTrigger(ElasticInstanceSchedule schedule) throws SchedulerException {
        return this.quartzScheduler.getTrigger(this.getTriggerKey(schedule));
    }

    @NotNull
    private TriggerKey getTriggerKey(ElasticInstanceSchedule schedule) {
        return new TriggerKey(TRIGGER_PREFIX + schedule.getId(), JOB_GROUP);
    }
}

