/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstancesMonitorJob;
import com.atlassian.bamboo.quartz.PreventJobExecutionUntilCompletedTriggerListener;
import com.atlassian.bamboo.schedule.BambooScheduler;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.KeyMatcher;
import org.quartz.utils.Key;

public class ElasticInstancesMonitor
implements BambooScheduler {
    private static final int INTERVAL_MINUTES = 1;
    private static final String ELASTIC_AGENT_MONITOR_JOB_GROUP = "elastic agent monitor job group";
    private static final String ELASTIC_AGENT_MONITOR_JOB_NAME = "elastic agent monitor job";
    private final TriggerKey TRIGGER_KEY = new TriggerKey("elastic agent monitor job", "elastic agent monitor job group");
    private final JobKey JOB_KEY = new JobKey("elastic agent monitor job", "elastic agent monitor job group");
    private final Scheduler quartzScheduler;
    private static final Logger log = Logger.getLogger(ElasticInstancesMonitor.class);

    public ElasticInstancesMonitor(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public void initialiseSchedule() {
        try {
            Trigger trigger = this.quartzScheduler.getTrigger(this.TRIGGER_KEY);
            if (trigger != null && trigger.mayFireAgain()) {
                return;
            }
            JobDetail jobDetail = JobBuilder.newJob(ElasticInstancesMonitorJob.class).withIdentity(this.JOB_KEY).build();
            trigger = TriggerBuilder.newTrigger().withIdentity("elasticAgentMonitorJobTrigger").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)1)).build();
            this.quartzScheduler.getListenerManager().addTriggerListener(PreventJobExecutionUntilCompletedTriggerListener.INSTANCE, (Matcher)KeyMatcher.keyEquals((Key)trigger.getKey()));
            this.quartzScheduler.scheduleJob(jobDetail, trigger);
            log.info((Object)"Build queue monitor running every 1m.");
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule elastic agent monitor job", (Throwable)e);
        }
    }
}

