/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.ServerLifecycleState;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticRunningInstancesOptimizer;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticFunctionalityFacade;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.server.ServerStatusProvider;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ElasticInstancesMonitorJob
implements Job {
    private static final Logger log = Logger.getLogger(ElasticInstancesMonitorJob.class);
    @Inject
    private ElasticRunningInstancesOptimizer agentQueueOptimiser;
    @Inject
    private ElasticFunctionalityFacade elasticFunctionalityFacade;
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private TextProvider textProvider;
    @Inject
    private ServerStatusProvider serverStatusProvider;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        boolean shouldManageElasticInstances;
        ElasticConfiguration elasticConfig = this.administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
        boolean bl = shouldManageElasticInstances = this.elasticFunctionalityFacade.isElasticSupportEnabled() && elasticConfig != null && elasticConfig.getAutomaticInstanceManagementConfig().isAutomaticInstanceManagementEnabled();
        if (!shouldManageElasticInstances) {
            return;
        }
        try {
            Object imagesToStart;
            if (this.mayStartNewImages() && !(imagesToStart = this.agentQueueOptimiser.getImagesToStart()).isEmpty()) {
                this.elasticFunctionalityFacade.startupAgents((Collection)imagesToStart);
            }
            for (RemoteElasticInstance instance : this.agentQueueOptimiser.getAgentsToStop()) {
                this.elasticFunctionalityFacade.addElasticLogEntry(log, this.textProvider.getText("elastic.manage.instance.will.be.stopped", new String[]{instance.getInstance().getInstanceId()}));
                this.elasticFunctionalityFacade.shutdownInstance(instance);
            }
        }
        catch (AWSException e) {
            log.error((Object)"Failed to adjust the number of elastic agents.", (Throwable)e);
        }
    }

    private boolean mayStartNewImages() {
        ServerLifecycleState lifecycleState = this.serverStatusProvider.getServerStatusInfo().getServerLifecycleState();
        return lifecycleState == ServerLifecycleState.RUNNING;
    }
}

