/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.schedule;

import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.Instance;
import com.atlassian.aws.AWSException;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticRunningInstancesOptimizer;
import com.atlassian.bamboo.agent.elastic.server.AutomaticInstanceManagementConfig;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.buildqueue.properties.DistributedProperties;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.resultsummary.AgentResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.util.BambooCollectionUtils;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.AgentIdleStatus;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.QueueManagerView;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import io.atlassian.fugue.Either;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Lazy;

public class ElasticRunningInstancesOptimizerImpl
implements ElasticRunningInstancesOptimizer {
    private static final Duration MAX_ELASTIC_AGENT_STARTUP_TIME = Duration.ofMinutes(SystemProperty.MAXIMUM_ALLOWED_ELASTIC_AGENT_STARTUP_TIME_MINUTES.getTypedValue());
    @Lazy
    @Inject
    private AgentManager agentManager;
    private final AgentResultsSummaryManager agentResultsSummaryManager;
    private final CachedPlanManager cachedPlanManager;
    private final ElasticInstanceManager elasticInstanceManager;
    private final BuildExecutionManager buildExecutionManager;
    @Inject
    private DeploymentsInProgressService deploymentInProgressService;
    @Inject
    private BuildQueueManager buildQueueManager;
    private final ElasticAccountBean elasticAccountConfigBean;
    private final AwsAccountBean awsAccountBean;
    private final BambooLicenseManager bambooLicenseManager;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final TextProvider textProvider;
    private final DeploymentResultService deploymentResultService;
    private static final Logger log = Logger.getLogger(ElasticRunningInstancesOptimizerImpl.class);
    private volatile Iterable<BuildQueueManager.QueueItemView<QueuedExecutableData>> queueView = Collections.emptyList();
    private QueueManagerView<CommonContext, QueuedExecutableData> queueManagerView;
    @NotNull
    private final Function<BuildQueueManager.QueueItemView<CommonContext>, BuildQueueManager.QueueItemView<QueuedExecutableData>> context2QueueItem = new Function<BuildQueueManager.QueueItemView<CommonContext>, BuildQueueManager.QueueItemView<QueuedExecutableData>>(){

        public BuildQueueManager.QueueItemView<QueuedExecutableData> apply(BuildQueueManager.QueueItemView<CommonContext> context) {
            BuildContext buildContext = (BuildContext)Narrow.downTo((Object)context.getView(), BuildContext.class);
            if (buildContext != null) {
                PlanKey planKey = ((BuildContext)Preconditions.checkNotNull((Object)buildContext)).getPlanResultKey().getPlanKey();
                ImmutableBuildable planByResultKey = (ImmutableBuildable)ElasticRunningInstancesOptimizerImpl.this.cachedPlanManager.getPlanByKey(planKey, ImmutableBuildable.class);
                if (planByResultKey == null) {
                    log.info((Object)("Skipping " + planKey + ", not found in the database"));
                    return new BuildQueueManager.QueueItemView(context.getQueuedResultKey(), null);
                }
                return new BuildQueueManager.QueueItemView(context.getQueuedResultKey(), (Object)new QueuedExecutableData(buildContext.getPlanResultKey()));
            }
            DeploymentContext deploymentContext = (DeploymentContext)Narrow.downTo((Object)context.getView(), DeploymentContext.class);
            if (deploymentContext != null) {
                return new BuildQueueManager.QueueItemView(context.getQueuedResultKey(), (Object)new QueuedExecutableData(deploymentContext.getDeploymentResultId()));
            }
            throw new IllegalArgumentException("Executable context that is neither build not deployment: " + context.getClass().getName());
        }
    };

    public ElasticRunningInstancesOptimizerImpl(AdministrationConfigurationAccessor administrationConfigurationAccessor, AgentResultsSummaryManager agentResultsSummaryManager, AwsAccountBean awsAccountBean, BambooLicenseManager bambooLicenseManager, BuildExecutionManager buildExecutionManager, BuildQueueManager buildQueueManager, CachedPlanManager cachedPlanManager, DeploymentResultService deploymentResultService, ElasticAccountBean elasticAccountBean, ElasticInstanceManager elasticInstanceManager, TextProvider textProvider) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.agentResultsSummaryManager = agentResultsSummaryManager;
        this.awsAccountBean = awsAccountBean;
        this.bambooLicenseManager = bambooLicenseManager;
        this.buildExecutionManager = buildExecutionManager;
        this.cachedPlanManager = cachedPlanManager;
        this.deploymentResultService = deploymentResultService;
        this.elasticAccountConfigBean = elasticAccountBean;
        this.elasticInstanceManager = elasticInstanceManager;
        this.textProvider = textProvider;
        this.queueManagerView = QueueManagerView.newView(buildQueueManager, this.context2QueueItem);
    }

    @Override
    @NotNull
    public Collection<ElasticImageConfiguration> getImagesToStart() {
        int numToStart;
        ArrayList<String> elasticLogMessages = new ArrayList<String>();
        List<ElasticImageConfiguration> mustStartImages = this.getMustStartImages();
        String logMessage = this.getMustStartImagesLogMessage(mustStartImages, this.getNumOfEmptySlots());
        if (logMessage != null) {
            elasticLogMessages.add(logMessage);
        }
        log.debug((Object)("Must start images: " + this.toNames(mustStartImages)));
        ArrayList<ElasticImageConfiguration> toStart = new ArrayList<ElasticImageConfiguration>(mustStartImages);
        List elasticBuilds = BambooIterables.stream((Iterable)this.buildQueueManager.getQueuedExecutables()).map(BuildQueueManager.QueuedResultKey::getResultKey).filter(resultKey -> !this.getImagesForQueuedExecutable((ResultKey)resultKey).isEmpty()).collect(Collectors.toList());
        log.debug((Object)("Builds that have an image executor listed: " + elasticBuilds));
        int numOfStartingElasticInstances = this.getNumOfStartingElasticInstances();
        Collection<QueuedExecutableData> queuedExecutableData = this.getQueuedExecutableData();
        int elasticBuildsInQueueWithNoStartingOrArrangedAgents = elasticBuilds.size() - numOfStartingElasticInstances - toStart.size();
        if (elasticBuildsInQueueWithNoStartingOrArrangedAgents >= this.getAutomaticInstanceManagementConfig().getElasticBuildsInQueueThreshold() && queuedExecutableData.size() >= this.getAutomaticInstanceManagementConfig().getTotalBuildInQueueThreshold() && this.getAverageTimeInQueue(queuedExecutableData) >= this.getAutomaticInstanceManagementConfig().getAverageTimeInQueueThreshold()) {
            int numberOfEmptySlotsLeft = this.getNumOfEmptySlots() - toStart.size();
            List<ElasticImageConfiguration> mostNeededElasticConfigurations = this.findMostNeededElasticConfigurations(Math.min(numberOfEmptySlotsLeft, elasticBuilds.size() - numOfStartingElasticInstances));
            String logMessage2 = this.getRequestedImagesLogMessage(mostNeededElasticConfigurations, Math.min(numberOfEmptySlotsLeft, mostNeededElasticConfigurations.size()), queuedExecutableData.size(), elasticBuilds.size(), numOfStartingElasticInstances);
            if (logMessage2 != null) {
                elasticLogMessages.add(logMessage2);
            }
            log.debug((Object)("Most needed configurations: " + this.toNames(mostNeededElasticConfigurations)));
            toStart.addAll(mostNeededElasticConfigurations);
        }
        if ((numToStart = Math.min(this.getNumOfEmptySlots(), toStart.size())) == 0) {
            return Collections.emptyList();
        }
        try {
            long instancesStartedByBamboosCnt = this.getNumberOfInstancesStartedByBamboos();
            int awsNumSpotRequestsPending = this.awsAccountBean.getAwsAccount().describePendingSpotInstanceRequests(new String[0]).size();
            long awsTotal = (long)awsNumSpotRequestsPending + instancesStartedByBamboosCnt;
            ElasticConfiguration elasticConfig = this.getNonNullElasticConfig();
            int maxNonBambooInstances = elasticConfig.getAutomaticInstanceManagementConfig().getMaxNonBambooInstances();
            int bambooRequestedAndRunningInstances = this.elasticInstanceManager.getAllElasticRemoteAgents().size();
            long nonBambooInstances = awsTotal - (long)bambooRequestedAndRunningInstances;
            String message = "AWS account has " + instancesStartedByBamboosCnt + " elastic instances started by Bamboo server(s) and has " + awsNumSpotRequestsPending + " spot requests pending, " + awsTotal + " in total. Of these, Bamboo controls " + bambooRequestedAndRunningInstances + ".";
            if (nonBambooInstances > (long)maxNonBambooInstances) {
                log.warn((Object)(message + " There are " + nonBambooInstances + " non-Bamboo instances, the maximum allowed is " + maxNonBambooInstances + ", not starting any instances. Please shut down non-Bamboo instances from AWS console or Bamboo's Disconnected Instances page. Alternatively, you can increase the maximum allowed number of non-Bamboo instances in Elastic Bamboo Configuration."));
                this.elasticInstanceManager.addElasticLogEntry(log, this.textProvider.getText("elastic.manage.instance.unknown.instances.limit", (List)Lists.newArrayList((Object[])new Object[]{nonBambooInstances, maxNonBambooInstances})));
                numToStart = 0;
            } else {
                for (String elasticLogMessage : elasticLogMessages) {
                    this.elasticInstanceManager.addElasticLogEntry(log, elasticLogMessage);
                }
                log.info((Object)message);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to access AWS account status, not starting any instances.", (Throwable)e);
            return Collections.emptyList();
        }
        return toStart.subList(0, numToStart);
    }

    private Set<String> toNames(List<ElasticImageConfiguration> mustStartImages) {
        return mustStartImages.stream().map(ElasticImageConfiguration::getConfigurationName).collect(Collectors.toSet());
    }

    @NotNull
    private Collection<ElasticImageConfiguration> getImagesForQueuedExecutable(ResultKey resultKey) {
        Collection imagesForQueuedExecutable = this.buildQueueManager.getImagesForQueuedExecutable(resultKey);
        if (imagesForQueuedExecutable == null) {
            return Collections.emptyList();
        }
        return imagesForQueuedExecutable.stream().filter(image -> !image.isDisabled()).collect(Collectors.toList());
    }

    @NotNull
    private ElasticConfiguration getNonNullElasticConfig() {
        ElasticConfiguration elasticConfig = this.elasticAccountConfigBean.getElasticConfig();
        Preconditions.checkState((elasticConfig != null ? 1 : 0) != 0, (Object)"Elastic config should be not null");
        return elasticConfig;
    }

    private long getNumberOfInstancesStartedByBamboos() throws AWSException {
        Predicate<Instance> isStartedByBambooServer = instance -> {
            for (GroupIdentifier groupIdentifier : instance.getSecurityGroups()) {
                if (!groupIdentifier.getGroupName().equals(this.elasticInstanceManager.getBambooControlTag())) continue;
                return true;
            }
            return false;
        };
        return this.awsAccountBean.getAwsAccount().getAllInstances().stream().filter(isStartedByBambooServer).count();
    }

    @Nullable
    private String getRequestedImagesLogMessage(List<ElasticImageConfiguration> requestedImages, int maxToStart, int buildQueueSize, int elasticBuildsInQueue, int numberOfStartingElasticInstances) {
        if (requestedImages.isEmpty() || maxToStart < 1) {
            return null;
        }
        return this.textProvider.getText("elastic.manage.instance.will.be.started.thresholds.reached", new String[]{Integer.toString(Math.min(maxToStart, requestedImages.size())), Integer.toString(buildQueueSize), Integer.toString(elasticBuildsInQueue), Integer.toString(numberOfStartingElasticInstances)});
    }

    @Nullable
    private String getMustStartImagesLogMessage(List<ElasticImageConfiguration> mustStartImages, int maxToStart) {
        if (mustStartImages.isEmpty() || maxToStart < 1) {
            return null;
        }
        return this.textProvider.getText("elastic.manage.instance.will.be.started.no.other.agents", new String[]{Integer.toString(Math.min(maxToStart, mustStartImages.size()))});
    }

    private int getNumOfEmptySlots() {
        int elasticConfigAgentLimit = this.getNonNullElasticConfig().getMaxConcurrentInstances();
        int allElasticInstances = this.elasticInstanceManager.getAllElasticRemoteAgents().size();
        int remoteAgentsAllowedByLicense = this.bambooLicenseManager.getAllowedNumberOfRemoteAgents();
        if (remoteAgentsAllowedByLicense < 0) {
            remoteAgentsAllowedByLicense = Integer.MAX_VALUE;
        }
        boolean onlineOnly = true;
        int nonElasticAgentNumber = this.agentManager.getAllRemoteAgents(true).size() - this.agentManager.getOnlineElasticAgents().size();
        int remainingLicenseLimit = remoteAgentsAllowedByLicense - allElasticInstances - nonElasticAgentNumber;
        int remainingElasticConfigLimit = elasticConfigAgentLimit - allElasticInstances;
        int licenseAndElasticLimit = Math.min(remainingLicenseLimit, remainingElasticConfigLimit);
        int throttlingLimit = this.getAutomaticInstanceManagementConfig().getMaxElasticInstancesToStartAtOnce();
        return Math.max(0, Math.min(throttlingLimit, licenseAndElasticLimit));
    }

    private int getNumOfStartingElasticInstances() {
        return this.elasticInstanceManager.getInstancesWithStartingAgents().size() + this.elasticInstanceManager.getRequestedElasticRemoteAgents().size() + this.elasticInstanceManager.getStartingElasticInstances().size();
    }

    private List<ElasticImageConfiguration> findMostNeededElasticConfigurations(int numberToFind) {
        List<Map.Entry<ElasticImageConfiguration, Long>> list = this.getElasticImagesOrderedByNumOfBuildsInQueueTheyCanRun();
        ArrayList<ElasticImageConfiguration> ret = new ArrayList<ElasticImageConfiguration>();
        for (Map.Entry<ElasticImageConfiguration, Long> entry : list) {
            int i = 0;
            while ((long)i < entry.getValue()) {
                if (numberToFind > 0) {
                    ret.add(entry.getKey());
                    --numberToFind;
                } else {
                    return ret;
                }
                ++i;
            }
        }
        return ret;
    }

    private List<Map.Entry<ElasticImageConfiguration, Long>> getElasticImagesOrderedByNumOfBuildsInQueueTheyCanRun() {
        Map map = BambooIterables.stream((Iterable)this.buildQueueManager.getQueuedExecutables()).map(BuildQueueManager.QueuedResultKey::getResultKey).map(this::getImagesForQueuedExecutable).flatMap(Collection::stream).collect(Collectors.groupingBy(java.util.function.Function.identity(), Collectors.counting()));
        return BambooCollectionUtils.sortByValue(map);
    }

    private long getAverageTimeInQueue(Collection<QueuedExecutableData> buildQueue) {
        int count = 0;
        long total = 0L;
        for (QueuedExecutableData requirementSetOfExecutable : buildQueue) {
            Date queuedDate = (Date)requirementSetOfExecutable.queuedDate.get();
            if (queuedDate == null) {
                if (requirementSetOfExecutable.planResulKeyOrDeploymentResultId.isLeft()) {
                    CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)requirementSetOfExecutable.planResulKeyOrDeploymentResultId.left().get());
                    if (currentlyBuilding != null && currentlyBuilding.isCurrentlyQueuedOnly()) {
                        queuedDate = currentlyBuilding.getQueueTime();
                        requirementSetOfExecutable.queuedDate.set(queuedDate);
                    }
                } else {
                    DeploymentResult deploymentResult = this.deploymentResultService.getDeploymentResult(((Long)requirementSetOfExecutable.planResulKeyOrDeploymentResultId.right().get()).longValue());
                    if (deploymentResult != null && deploymentResult.getStartedDate() == null && deploymentResult.getQueuedDate() != null) {
                        queuedDate = deploymentResult.getQueuedDate();
                        requirementSetOfExecutable.queuedDate.set(queuedDate);
                    }
                }
            }
            if (queuedDate == null) continue;
            ++count;
            total += System.currentTimeMillis() - queuedDate.getTime();
        }
        return count == 0 ? 0L : total / (long)count;
    }

    private List<ElasticImageConfiguration> getMustStartImages() {
        List<Map.Entry<ElasticImageConfiguration, Long>> imageBuildingMatrix = this.getElasticImagesOrderedByNumOfBuildsInQueueTheyCanRun();
        List allRunningOrStartingConfigurations = this.elasticInstanceManager.getAllElasticRemoteAgents().stream().map(RemoteElasticInstance::getConfiguration).collect(Collectors.toList());
        List executablesWithoutAgentsOrWithPendingAgent = BambooIterables.stream((Iterable)this.buildQueueManager.getQueuedExecutables()).map(BuildQueueManager.QueuedResultKey::getResultKey).filter(resultKey -> {
            Set executorsForQueuedExecutable = this.buildQueueManager.getExecutorsForQueuedExecutable(resultKey);
            return executorsForQueuedExecutable != null && executorsForQueuedExecutable.isEmpty();
        }).collect(Collectors.toList());
        HashSet<ElasticImageConfiguration> mustStartImages = new HashSet<ElasticImageConfiguration>();
        HashSet<ResultKey> executablesThatCannotNotBeBuiltWithoutStartingAnAgent = new HashSet<ResultKey>();
        block0: for (ResultKey executable : executablesWithoutAgentsOrWithPendingAgent) {
            Collection<ElasticImageConfiguration> executableImages = this.getImagesForQueuedExecutable(executable);
            if (executableImages.isEmpty() || CollectionUtils.containsAny(executableImages, allRunningOrStartingConfigurations)) continue;
            executablesThatCannotNotBeBuiltWithoutStartingAnAgent.add(executable);
            if (CollectionUtils.containsAny(executableImages, mustStartImages)) continue;
            for (Map.Entry<ElasticImageConfiguration, Long> entry : imageBuildingMatrix) {
                if (!executableImages.contains(entry.getKey())) continue;
                mustStartImages.add(entry.getKey());
                continue block0;
            }
        }
        if (!executablesThatCannotNotBeBuiltWithoutStartingAnAgent.isEmpty()) {
            this.elasticInstanceManager.addElasticLogEntry(log, this.textProvider.getText("elastic.manage.instance.will.be.started.for.build", Collections.singletonList(StringUtils.join(executablesThatCannotNotBeBuiltWithoutStartingAnAgent, (String)", "))));
        }
        return new ArrayList<ElasticImageConfiguration>(mustStartImages);
    }

    @Override
    @NotNull
    public Collection<RemoteElasticInstance> getAgentsToStop() {
        final Set<ElasticImageConfiguration> allImagesCapableOfExecutingBuildsInQueue = this.getImagesForQueuedExecutables();
        Predicate<RemoteElasticInstance> instanceShouldBeStopped = new Predicate<RemoteElasticInstance>(){

            @Override
            public boolean test(RemoteElasticInstance instance) {
                boolean agentIsShutdownable;
                BuildAgent agent = ElasticRunningInstancesOptimizerImpl.this.agentManager.getAgent(instance.getRemoteAgent());
                if (agent == null) {
                    boolean isUptimeLongerThanGracePeriod = Comparators.isGreater(this.getInstanceUptime(instance), MAX_ELASTIC_AGENT_STARTUP_TIME);
                    if (isUptimeLongerThanGracePeriod) {
                        log.warn((Object)String.format("Agent on instance %s has been pending for more than %d minutes, terminating instance. You can adjust this timeout using %s system property", instance.getInstance().getInstanceId(), MAX_ELASTIC_AGENT_STARTUP_TIME.toMinutes(), SystemProperty.MAXIMUM_ALLOWED_ELASTIC_AGENT_STARTUP_TIME_MINUTES.getKey()));
                    }
                    return isUptimeLongerThanGracePeriod;
                }
                if (allImagesCapableOfExecutingBuildsInQueue.contains(instance.getConfiguration())) {
                    log.debug((Object)("Instance " + instance.getInstance().getInstanceId() + " will not be stopped because something in the queue may be built on it"));
                    return false;
                }
                boolean bl = agentIsShutdownable = this.hasNothingRunning(agent) && agent.isEnabled() && !agent.isRequestedToBeStopped() && instance.isShutdownable();
                if (!agentIsShutdownable) {
                    return false;
                }
                log.debug((Object)("Instance " + instance.getInstance().getInstanceId() + " eligible for shutdown after the agent check"));
                return this.isIdleLongerThan(agent, ElasticRunningInstancesOptimizerImpl.this.getAutomaticInstanceManagementConfig().getInstanceIdleTimeThreshold()) && this.isAtTheEndOfBillingPeriod(instance);
            }

            private boolean isIdleLongerThan(BuildAgent agent, long elasticAgentIdleThresholdMillis) {
                Date lastActivity = null;
                try {
                    BuildResultsSummary summary = ElasticRunningInstancesOptimizerImpl.this.agentResultsSummaryManager.getLatestSummaryForAgent(agent.getId());
                    if (summary != null) {
                        lastActivity = summary.getBuildCompletedDate();
                    } else {
                        DistributedProperties properties = (DistributedProperties)Narrow.reinterpret((Object)agent.getDefinition(), DistributedProperties.class);
                        if (properties != null) {
                            lastActivity = properties.getLastStartupTime();
                        }
                    }
                    if (lastActivity == null) {
                        log.warn((Object)("Unable to retrieve time of last activity for agent " + agent.getName()));
                    }
                }
                catch (RuntimeException e) {
                    log.warn((Object)"Unable to get last activity date.", (Throwable)e);
                }
                return lastActivity == null || BambooDateUtils.getMillisDistanceToNow(lastActivity) >= elasticAgentIdleThresholdMillis;
            }

            private boolean isAtTheEndOfBillingPeriod(RemoteElasticInstance instance) {
                if (instance.getConfiguration().isPerSecondBillingEnabled()) {
                    return true;
                }
                Duration endOfBillingPeriodThreshold = Duration.ofMinutes(55L);
                return this.getInstanceUptime(instance).getSeconds() % 3600L > endOfBillingPeriodThreshold.getSeconds();
            }

            private Duration getInstanceUptime(RemoteElasticInstance instance) {
                Date instanceLaunchTime = instance.getInstance().getInstanceStatus().getLaunchTime();
                if (instanceLaunchTime == null) {
                    log.debug((Object)("The launch time of " + instance.getInstance().getInstanceId() + " is not (yet) known, assuming it's just starting"));
                    return Duration.ZERO;
                }
                return BambooDateUtils.getDurationToNow((Date)instanceLaunchTime);
            }

            private boolean hasNothingRunning(BuildAgent agent) {
                boolean isIdle = agent.getAgentStatus() instanceof AgentIdleStatus;
                boolean executesNoBuilds = ElasticRunningInstancesOptimizerImpl.this.buildExecutionManager.getBuildRunningOnAgent(Long.valueOf(agent.getId())) == null;
                boolean executesNoDeployments = ElasticRunningInstancesOptimizerImpl.this.deploymentInProgressService.getDeploymentExecutingOnAgent(agent.getId()) == null;
                return isIdle && executesNoBuilds && executesNoDeployments;
            }
        };
        return this.elasticInstanceManager.getElasticRemoteAgents().stream().filter(instanceShouldBeStopped).collect(Collectors.toList());
    }

    private Collection<QueuedExecutableData> getQueuedExecutableData() {
        this.queueView = this.queueManagerView.getQueueView(this.queueView);
        return BambooIterables.stream(this.queueView).map(BuildQueueManager.QueueItemView::getView).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    private Set<ElasticImageConfiguration> getImagesForQueuedExecutables() {
        return BambooIterables.stream((Iterable)this.buildQueueManager.getQueuedExecutables()).map(BuildQueueManager.QueuedResultKey::getResultKey).map(this::getImagesForQueuedExecutable).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @NotNull
    private AutomaticInstanceManagementConfig getAutomaticInstanceManagementConfig() {
        ElasticConfiguration elasticConfig = this.administrationConfigurationAccessor.getAdministrationConfiguration().getElasticConfig();
        if (elasticConfig != null) {
            return elasticConfig.getAutomaticInstanceManagementConfig();
        }
        throw new IllegalStateException("Elastic instance optimizer cannot run when elastic Bamboo has not been enabled");
    }

    private class QueuedExecutableData {
        private final Either<PlanResultKey, Long> planResulKeyOrDeploymentResultId;
        private final AtomicReference<Date> queuedDate = new AtomicReference();

        private QueuedExecutableData(PlanResultKey planResultKey) {
            this.planResulKeyOrDeploymentResultId = Either.left((Object)planResultKey);
        }

        private QueuedExecutableData(long deploymentResultId) {
            this.planResulKeyOrDeploymentResultId = Either.right((Object)deploymentResultId);
        }
    }
}

