/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.Instance;
import com.atlassian.aws.AWSAccount;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.RemoteEC2Instance;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.aws.AwsAccountBean;
import com.atlassian.bamboo.agent.elastic.server.ElasticAccountManagementService;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.agent.elastic.server.RemoteElasticInstance;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ElasticAccountManagementServiceImpl
implements ElasticAccountManagementService {
    private static final Collection<String> UNRELATED_ELASTIC_INSTANCES_STATE_FILTER = Sets.newHashSet((Object[])new String[]{AwsSupportConstants.InstanceStateName.Pending.toString(), AwsSupportConstants.InstanceStateName.ShuttingDown.toString(), AwsSupportConstants.InstanceStateName.Terminated.toString()});
    private AwsAccountBean awsAccountBean;
    private AgentManager agentManager;
    private ElasticInstanceManager elasticInstanceManager;

    public ElasticAccountManagementServiceImpl(AwsAccountBean awsAccountBean, AgentManager agentManager, ElasticInstanceManager elasticInstanceManager) {
        this.awsAccountBean = awsAccountBean;
        this.agentManager = agentManager;
        this.elasticInstanceManager = elasticInstanceManager;
    }

    @NotNull
    public Collection<Instance> getDisconnectedElasticInstances() throws AWSException {
        Set controlledElasticAgents = this.agentManager.getOnlineElasticAgents().stream().map(input -> (ElasticAgentDefinition)input.getDefinition()).collect(Collectors.toSet());
        Collection elasticInstancesOnAwsAccount = this.getAWSAccount().getAllInstances();
        Collection allRunningInstanceIds = elasticInstancesOnAwsAccount.stream().map(Instance::getInstanceId).collect(Collectors.toList());
        List runningElasticAgentsFromThisServer = this.agentManager.getAllElasticAgentDefinitions(allRunningInstanceIds);
        Set notControlledInstanceIds = runningElasticAgentsFromThisServer.stream().filter(agent -> !controlledElasticAgents.contains(agent)).map(ElasticAgentDefinition::getElasticInstanceId).collect(Collectors.toSet());
        return elasticInstancesOnAwsAccount.stream().filter(input -> notControlledInstanceIds.contains(input.getInstanceId())).collect(Collectors.toList());
    }

    @NotNull
    public Collection<Instance> getUnrelatedElasticInstances() throws AWSException {
        HashSet<String> runningInstanceIds = new HashSet<String>();
        for (RemoteElasticInstance instance : this.elasticInstanceManager.getElasticRemoteAgents()) {
            RemoteEC2Instance remoteInstance = instance.getInstance();
            if (remoteInstance == null) continue;
            runningInstanceIds.add(remoteInstance.getInstanceId());
        }
        Collection<Instance> disconnectedElasticInstances = this.getDisconnectedElasticInstances();
        return this.getAWSAccount().getAllInstances().stream().filter(instanceInfo -> !UNRELATED_ELASTIC_INSTANCES_STATE_FILTER.contains(instanceInfo.getState().getName())).filter(instanceInfo -> !runningInstanceIds.contains(instanceInfo.getInstanceId())).filter(instanceInfo -> !disconnectedElasticInstances.contains(instanceInfo)).collect(Collectors.toCollection(ArrayList::new));
    }

    private AWSAccount getAWSAccount() throws AWSException {
        return this.awsAccountBean.getAwsAccount();
    }
}

