/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.aws.ec2.configuration.ImageFileDao;
import com.atlassian.bamboo.agent.elastic.server.AutomaticInstanceManagementConfig;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElasticConfigurationImpl
implements ElasticConfiguration,
Serializable {
    private static final int DEFAULT_AUTO_SHUTDOWN_DELAY = 300;
    private String awsAccessKeyId;
    private String awsSecretKey;
    private int maxConcurrentInstances;
    private boolean enabled = false;
    private boolean autoShutdownEnabled = true;
    private int autoShutdownDelay = 300;
    private boolean uploadingOfAwsAccountDetailsEnabled;
    private String awsPrivateKeyFile;
    private String awsCertFile;
    private AutomaticInstanceManagementConfig automaticInstanceManagementConfig;
    private boolean isPublicIpForVpcEnabled;
    private AwsSupportConstants.Region region;

    public String getAwsAccessKeyId() {
        return this.awsAccessKeyId;
    }

    public void setAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    public int getMaxConcurrentInstances() {
        return this.maxConcurrentInstances;
    }

    public void setMaxConcurrentInstances(int maxConcurrentInstances) {
        this.maxConcurrentInstances = maxConcurrentInstances;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAutoShutdownEnabled() {
        return this.autoShutdownEnabled;
    }

    public void setAutoShutdownEnabled(boolean autoShutdownEnabled) {
        this.autoShutdownEnabled = autoShutdownEnabled;
    }

    public int getAutoShutdownDelay() {
        if (this.autoShutdownDelay > 0) {
            return this.autoShutdownDelay;
        }
        return 300;
    }

    public void setAutoShutdownDelay(int autoShutdownDelay) {
        this.autoShutdownDelay = autoShutdownDelay;
    }

    public String getAwsPrivateKeyFile() {
        return this.awsPrivateKeyFile;
    }

    public void setAwsPrivateKeyFile(String awsPrivateKeyFile) {
        this.awsPrivateKeyFile = awsPrivateKeyFile;
    }

    public String getAwsCertFile() {
        return this.awsCertFile;
    }

    public void setAwsCertFile(String awsCertFile) {
        this.awsCertFile = awsCertFile;
    }

    public boolean isUploadingOfAwsAccountDetailsEnabled() {
        return this.uploadingOfAwsAccountDetailsEnabled;
    }

    public void setUploadingOfAwsAccountDetailsEnabled(boolean uploadingOfAwsAccountDetailsEnabled) {
        this.uploadingOfAwsAccountDetailsEnabled = uploadingOfAwsAccountDetailsEnabled;
    }

    public AutomaticInstanceManagementConfig getAutomaticInstanceManagementConfig() {
        if (this.automaticInstanceManagementConfig == null) {
            this.automaticInstanceManagementConfig = AutomaticInstanceManagementConfig.DISABLED_INSTANCE_MANAGEMENT_CONFIG;
        }
        return this.automaticInstanceManagementConfig;
    }

    public void setAutomaticInstanceManagementConfig(AutomaticInstanceManagementConfig config) {
        this.automaticInstanceManagementConfig = config;
    }

    public void setPublicIpForVpcEnabled(boolean value) {
        this.isPublicIpForVpcEnabled = value;
    }

    public boolean isPublicIpForVpcEnabled() {
        return this.isPublicIpForVpcEnabled;
    }

    @NotNull
    public static ImageData getShippedElasticImageData() throws IOException {
        return ImageFileDao.readArtifact((String)"atlassian-bamboo-agent-elastic-s3-bucket");
    }

    @NotNull
    public AwsSupportConstants.Region getRegion() {
        return (AwsSupportConstants.Region)MoreObjects.firstNonNull((Object)this.region, (Object)AwsSupportConstants.Region.US_EAST_1);
    }

    public void setRegion(@NotNull AwsSupportConstants.Region region) {
        this.region = region;
    }

    @Nullable
    public Iterable<String> getInstallerRunCommand() {
        return null;
    }
}

