/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationDao;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElasticImageConfigurationAccessorImpl
implements ElasticImageConfigurationAccessor {
    private static final Logger log = Logger.getLogger(ElasticImageConfigurationAccessorImpl.class);
    private final ElasticImageConfigurationDao elasticImageConfigurationDao;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final ThreadScopedCaches.Key<String, List<ElasticImageConfiguration>> CACHE_KEY = ThreadScopedCaches.makeKey(this.getClass());

    public ElasticImageConfigurationAccessorImpl(@NotNull ElasticImageConfigurationDao elasticImageConfigurationDao, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.elasticImageConfigurationDao = elasticImageConfigurationDao;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    @Nullable
    public ElasticImageConfiguration getElasticImageConfigurationById(long configurationId) {
        ElasticImageConfiguration configuration = this.elasticImageConfigurationDao.findById(configurationId);
        if (configuration == null) {
            log.error((Object)("Elastic Configuration ID [" + configurationId + "] is not valid, could not retrieve configuration."));
        }
        return configuration;
    }

    @NotNull
    public List<ElasticImageConfiguration> getElasticImageConfigurationsByName(@NotNull String configurationName, @NotNull AwsSupportConstants.Region region) {
        return this.elasticImageConfigurationDao.getElasticImageConfigurationsByName(configurationName, region);
    }

    @NotNull
    public List<ElasticImageConfiguration> getElasticImageConfigurationsShippedWithBamboo() {
        return this.elasticImageConfigurationDao.getImages(null, null, null, null, Boolean.valueOf(true));
    }

    @NotNull
    public List<ElasticImageConfiguration> getAllElasticImageConfigurations() {
        return this.elasticImageConfigurationDao.findAll();
    }

    @NotNull
    public List<ElasticImageConfiguration> getAllElasticImageConfigurationsForCurrentRegion() {
        List getAllElasticImageConfigurationsForCurrentRegion = (List)ThreadScopedCaches.getValue(this.CACHE_KEY, (Object)"getAllElasticImageConfigurationsForCurrentRegion", () -> {
            AwsSupportConstants.Region currentRegion = this.getCurrentRegion();
            if (currentRegion == null) {
                return Collections.emptyList();
            }
            return this.elasticImageConfigurationDao.getImages(currentRegion, null, null, null, null);
        });
        return getAllElasticImageConfigurationsForCurrentRegion;
    }

    @Nullable
    private AwsSupportConstants.Region getCurrentRegion() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        ElasticConfiguration elasticConfig = administrationConfiguration.getElasticConfig();
        if (elasticConfig == null) {
            return null;
        }
        return elasticConfig.isEnabled() ? elasticConfig.getRegion() : null;
    }
}

