/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationImpl;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElasticImageConfigurationCapabilities {
    private static final String IAM_INSTANCE_PROFILE_KEY = "system.agent.environment.iam.instance.profile";
    private static final String EC2_INSTANCE_TYPE_KEY = "system.agent.environment.ec2.instance.type";
    private static final String EBS_OPTIMISED = "system.agent.environment.ebs.optimised";

    private ElasticImageConfigurationCapabilities() {
    }

    @Nullable
    public static String getIamInstanceProfile(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        return ElasticImageConfigurationCapabilities.getCapabilityValue(elasticImageConfiguration, IAM_INSTANCE_PROFILE_KEY);
    }

    public static void setIamInstanceProfile(@NotNull ElasticImageConfiguration elasticImageConfiguration, @Nullable String iamInstanceProfileArnOrName) {
        if (StringUtils.isBlank((CharSequence)iamInstanceProfileArnOrName)) {
            ElasticImageConfigurationCapabilities.removeCapability(elasticImageConfiguration, IAM_INSTANCE_PROFILE_KEY);
        } else {
            ElasticImageConfigurationCapabilities.setCapability(elasticImageConfiguration, IAM_INSTANCE_PROFILE_KEY, iamInstanceProfileArnOrName);
        }
    }

    public static boolean isEbsOptimised(ElasticImageConfiguration elasticImageConfiguration) {
        return BooleanUtils.toBoolean((String)ElasticImageConfigurationCapabilities.getCapabilityValue(elasticImageConfiguration, EBS_OPTIMISED));
    }

    public static void setEbsOptimised(ElasticImageConfigurationImpl elasticImageConfiguration, boolean ebsOptimised) {
        ElasticImageConfigurationCapabilities.setCapability(elasticImageConfiguration, EBS_OPTIMISED, Boolean.toString(ebsOptimised));
    }

    public static void setEc2InstanceType(ElasticImageConfiguration elasticImageConfiguration, InstanceType instanceType) {
        ElasticImageConfigurationCapabilities.setCapability(elasticImageConfiguration, EC2_INSTANCE_TYPE_KEY, instanceType.toString());
    }

    private static void setCapability(ElasticImageConfiguration elasticImageConfiguration, String key, @Nullable String value) {
        elasticImageConfiguration.getCapabilitySet().addCapability((Capability)new CapabilityImpl(key, value));
    }

    @Nullable
    private static String getCapabilityValue(ElasticImageConfiguration elasticImageConfiguration, String key) {
        Capability capability = elasticImageConfiguration.getCapabilitySet().getCapability(key);
        return capability != null ? capability.getValue() : null;
    }

    private static void removeCapability(ElasticImageConfiguration elasticImageConfiguration, String key) {
        elasticImageConfiguration.getCapabilitySet().removeCapability(key);
    }
}

