/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class ElasticImageConfigurationFunctions {
    private ElasticImageConfigurationFunctions() {
    }

    public static Predicate<ElasticImageConfiguration> isShippedWithBamboo() {
        return new Predicate<ElasticImageConfiguration>(){

            public boolean apply(ElasticImageConfiguration elasticImageConfiguration) {
                return elasticImageConfiguration.isShippedWithBamboo();
            }
        };
    }

    public static String getStockImageConfigurationName(@NotNull ElasticImageConfiguration image) {
        String osName = StringUtils.defaultString((String)image.getOsName(), (String)"Unknown OS");
        String imageArchitecture = image.getArchitecture() == AwsSupportConstants.Architecture.i386 ? "32bit" : null;
        String rootDeviceType = image.getRootDeviceType() == AwsSupportConstants.RootDeviceType.S3 ? "S3" : null;
        return Joiner.on((String)" ").skipNulls().join((Object)osName, (Object)imageArchitecture, new Object[]{rootDeviceType, "stock image"});
    }
}

