/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.google.common.base.Joiner;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElasticImageConfigurationHelper {
    private ElasticImageConfigurationHelper() {
    }

    public static String getStockImageName(@NotNull ImageData.ImageDefinition image) {
        String osName = image.getOsName();
        return ElasticImageConfigurationHelper.getImageName(osName, image.getVirtualisation(), image.getImageArchitecture(), image.getRootDeviceType());
    }

    public static String getStockImageConfigurationName(@NotNull ElasticImageConfiguration image) {
        String osName = StringUtils.defaultString((String)image.getOsName(), (String)"Unknown OS");
        return ElasticImageConfigurationHelper.getImageName(osName, image.getVirtualisationType(), image.getArchitecture(), image.getRootDeviceType());
    }

    @NotNull
    private static String getImageName(String osName, AwsSupportConstants.Virtualisation virtualisationType, AwsSupportConstants.Architecture imageArchitecture, AwsSupportConstants.RootDeviceType rootDeviceType) {
        String rootDeviceTypeName = ElasticImageConfigurationHelper.getRootDeviceTypeName(rootDeviceType);
        String imageArchitectureName = ElasticImageConfigurationHelper.getImageArchitectureName(imageArchitecture);
        String virtualisationTypeName = ElasticImageConfigurationHelper.getVirtualisationName(virtualisationType);
        return Joiner.on((String)" ").skipNulls().join((Object)osName, (Object)virtualisationTypeName, new Object[]{imageArchitectureName, rootDeviceTypeName, "stock image"});
    }

    @Nullable
    private static String getImageArchitectureName(AwsSupportConstants.Architecture imageArchitecture) {
        return imageArchitecture == AwsSupportConstants.Architecture.i386 ? "32bit" : null;
    }

    @Nullable
    private static String getRootDeviceTypeName(AwsSupportConstants.RootDeviceType rootDeviceType) {
        return rootDeviceType == AwsSupportConstants.RootDeviceType.S3 ? "S3" : null;
    }

    private static String getVirtualisationName(AwsSupportConstants.Virtualisation virtualisation) {
        if (virtualisation == AwsSupportConstants.Virtualisation.PV) {
            return "PV";
        }
        return null;
    }
}

