/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.model.AvailabilityZoneId;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.core.Script;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.BambooStringUtils;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.ImageCapabilitySetImpl;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="ELASTIC_IMAGE")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class ElasticImageConfigurationImpl
extends BambooEntityObject
implements ElasticImageConfiguration,
Comparable<ElasticImageConfigurationImpl> {
    private static final Supplier<AgentAssignmentService> agentAssignmentService = ComponentAccessor.AGENT_ASSIGNMENT_SERVICE;
    private static final char SEPARATOR = ',';
    private static final Joiner JOINER = Joiner.on((char)',');
    private static final Splitter SPLITTER = Splitter.on((char)',');
    private String configurationName;
    private String configurationDescription;
    private String amiId;
    private String ebsSnapshotId;
    private boolean isLegacyEbsHandlingEnabled;
    private String instanceTypes;
    @Nullable
    private String availabilityZones;
    private ImageCapabilitySet capabilitySet;
    private boolean shippedWithBamboo;
    private boolean disabled;
    private String product;
    @Nullable
    private String subnetIds;
    private AwsSupportConstants.Region region;
    private AwsSupportConstants.Architecture architecture;
    private AwsSupportConstants.RootDeviceType rootDeviceType;
    private AwsSupportConstants.Platform platform;
    private List<Script> startupScripts = new ArrayList<Script>();
    private String imageFilesVersion;
    private String osName;
    private AwsSupportConstants.Virtualisation virtualisationType;
    private boolean perSecondBillingEnabled = true;
    private Integer rootFsSizeOverride;

    public String getConfigurationName() {
        return this.configurationName;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public boolean isEbsEnabled() {
        return this.getEbsSnapshotId() != null;
    }

    public String getEbsSnapshotId() {
        return BambooStringUtils.nullIfBlank((String)this.ebsSnapshotId);
    }

    public void setEbsSnapshotId(@Nullable String ebsSnapshotId) {
        this.ebsSnapshotId = BambooStringUtils.nullIfBlank((String)ebsSnapshotId);
    }

    public boolean isLegacyEbsHandlingEnabled() {
        return this.isLegacyEbsHandlingEnabled;
    }

    public void setLegacyEbsHandlingEnabled(boolean value) {
        this.isLegacyEbsHandlingEnabled = value;
    }

    @NotNull
    public EC2InstanceType getInstanceType() {
        return (EC2InstanceType)Iterables.get(this.getInstanceTypes(), (int)0);
    }

    @NotNull
    public Iterable<EC2InstanceType> getInstanceTypes() {
        return Arrays.stream(this.instanceTypes.split(",")).map(EC2InstanceType::valueOf).collect(Collectors.toList());
    }

    public void setInstanceType(EC2InstanceType instanceType) {
        this.setInstanceTypes(Collections.singleton(instanceType));
    }

    public void setInstanceTypes(@NotNull Iterable<EC2InstanceType> instanceTypes) {
        this.instanceTypes = ElasticImageConfigurationImpl.toString(instanceTypes);
    }

    @NotNull
    public static String toString(@NotNull Iterable<EC2InstanceType> instanceTypes) {
        return BambooIterables.stream(instanceTypes).map(Enum::name).collect(Collectors.joining(","));
    }

    public void setAvailabilityZone(@Nullable String availabilityZone) {
        this.availabilityZones = availabilityZone;
    }

    @NotNull
    public Collection<String> getAvailabilityZones() {
        if (StringUtils.isBlank((CharSequence)this.availabilityZones)) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(ElasticImageConfigurationImpl.split(this.availabilityZones));
    }

    private static Iterable<String> split(String string) {
        return SPLITTER.split((CharSequence)StringUtils.defaultString((String)string));
    }

    private static String join(Iterable<?> strings) {
        return JOINER.join(strings);
    }

    public void setAvailabilityZones(Iterable<AvailabilityZoneId> availabilityZones) {
        this.availabilityZones = ElasticImageConfigurationImpl.join(availabilityZones);
    }

    public String getConfigurationDescription() {
        return this.configurationDescription;
    }

    public void setConfigurationDescription(String configurationDescription) {
        this.configurationDescription = configurationDescription;
    }

    public boolean isShippedWithBamboo() {
        return this.shippedWithBamboo;
    }

    public void setShippedWithBamboo(boolean shippedWithBamboo) {
        this.shippedWithBamboo = shippedWithBamboo;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @NotNull
    public ImageCapabilitySet getCapabilitySet() {
        if (this.capabilitySet == null) {
            this.capabilitySet = new ImageCapabilitySetImpl();
        }
        return this.capabilitySet;
    }

    public void setCapabilitySet(@NotNull ImageCapabilitySet imageCapabilitySet) {
        this.capabilitySet = imageCapabilitySet;
    }

    @NotNull
    public String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public AwsSupportConstants.Region getRegion() {
        return this.region;
    }

    public void setSubnetId(@Nullable String subnetId) {
        this.subnetIds = subnetId;
    }

    @NotNull
    public Collection<String> getSubnetIds() {
        if (StringUtils.isBlank((CharSequence)this.subnetIds)) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(ElasticImageConfigurationImpl.split(this.subnetIds));
    }

    public void setSubnetIds(@NotNull Iterable<String> subnetIds) {
        this.subnetIds = ElasticImageConfigurationImpl.join(subnetIds);
    }

    public void setRegion(AwsSupportConstants.Region region) {
        this.region = region;
    }

    public AwsSupportConstants.Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(AwsSupportConstants.Architecture architecture) {
        this.architecture = architecture;
    }

    public AwsSupportConstants.Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(AwsSupportConstants.Platform platform) {
        this.platform = platform;
    }

    public AwsSupportConstants.RootDeviceType getRootDeviceType() {
        return this.rootDeviceType;
    }

    public void setRootDeviceType(AwsSupportConstants.RootDeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    @NotNull
    public List<Script> getStartupScripts() {
        return this.startupScripts;
    }

    public void setStartupScripts(@NotNull List<Script> startupScripts) {
        this.startupScripts = startupScripts;
    }

    public String getImageFilesVersion() {
        return this.imageFilesVersion;
    }

    public void setImageFilesVersion(String imageFilesLevel) {
        this.imageFilesVersion = imageFilesLevel;
    }

    @Nullable
    public String getOsName() {
        return this.osName;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    @Nullable
    public AwsSupportConstants.Virtualisation getVirtualisationType() {
        return this.virtualisationType;
    }

    public boolean isPerSecondBillingEnabled() {
        return this.perSecondBillingEnabled;
    }

    public void setPerSecondBillingEnabled(boolean perSecondBillingEnabled) {
        this.perSecondBillingEnabled = perSecondBillingEnabled;
    }

    @Nullable
    public Integer getRootFsSizeOverride() {
        return this.rootFsSizeOverride;
    }

    public void setRootFsSizeOverride(@Nullable Integer rootFsSizeOverride) {
        this.rootFsSizeOverride = rootFsSizeOverride;
    }

    public void setVirtualisationType(AwsSupportConstants.Virtualisation virtualisationType) {
        this.virtualisationType = virtualisationType;
    }

    public boolean isDedicated() {
        return !((AgentAssignmentService)agentAssignmentService.get()).getAgentAssignments().forExecutors(AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)this)).isEmpty();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getAmiId(), this.instanceTypes, this.ebsSnapshotId});
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElasticImageConfigurationImpl)) {
            return false;
        }
        ElasticImageConfigurationImpl rhs = (ElasticImageConfigurationImpl)o;
        return new EqualsBuilder().append((Object)this.getConfigurationName(), (Object)rhs.getConfigurationName()).append((Object)this.getAmiId(), (Object)rhs.getAmiId()).append((Object)this.getEbsSnapshotId(), (Object)rhs.getEbsSnapshotId()).append(this.isLegacyEbsHandlingEnabled, rhs.isLegacyEbsHandlingEnabled).append(this.perSecondBillingEnabled, rhs.perSecondBillingEnabled).append(this.getInstanceTypes(), rhs.getInstanceTypes()).append(this.getId(), rhs.getId()).append((Object)this.product, (Object)rhs.product).append((Object)this.region, (Object)rhs.region).append((Object)this.architecture, (Object)rhs.architecture).append((Object)this.platform, (Object)rhs.platform).append((Object)this.subnetIds, (Object)rhs.subnetIds).append((Object)this.rootDeviceType, (Object)rhs.rootDeviceType).append((Object)this.virtualisationType, (Object)rhs.virtualisationType).isEquals();
    }

    @Override
    public int compareTo(ElasticImageConfigurationImpl o) {
        return new CompareToBuilder().append((Object)this.getAmiId(), (Object)o.getAmiId()).append((Object)this.getConfigurationName(), (Object)o.getConfigurationName()).append((Object)this.getEbsSnapshotId(), (Object)o.getEbsSnapshotId()).append(this.perSecondBillingEnabled, o.perSecondBillingEnabled).append((Object)this.instanceTypes, (Object)o.instanceTypes).append(this.getId(), o.getId()).append((Object)this.product, (Object)o.product).append((Object)this.region, (Object)o.region).append((Object)this.architecture, (Object)o.architecture).append((Object)this.platform, (Object)o.platform).append((Object)this.subnetIds, (Object)o.subnetIds).append((Object)this.rootDeviceType, (Object)o.rootDeviceType).append((Object)this.virtualisationType, (Object)o.virtualisationType).toComparison();
    }
}

