/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.elastic.server;

import com.amazonaws.regions.Regions;
import com.atlassian.aws.AWSException;
import com.atlassian.aws.ec2.EC2InstanceType;
import com.atlassian.aws.ec2.awssdk.AwsSupportConstants;
import com.atlassian.aws.ec2.configuration.ImageData;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceSchedule;
import com.atlassian.bamboo.agent.elastic.schedule.ElasticInstanceScheduleManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfiguration;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationAccessor;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationDao;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationHelper;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationImpl;
import com.atlassian.bamboo.agent.elastic.server.ElasticImageConfigurationManager;
import com.atlassian.bamboo.agent.elastic.server.ElasticInstanceManager;
import com.atlassian.bamboo.buildqueue.ElasticAgentDefinition;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentService;
import com.atlassian.bamboo.buildqueue.manager.AgentAssignmentServiceHelper;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.event.elastic.ElasticImageConfigurationCreatedEvent;
import com.atlassian.bamboo.event.elastic.ElasticImageConfigurationRemovedEvent;
import com.atlassian.bamboo.event.elastic.ElasticImageConfigurationUpdatedEvent;
import com.atlassian.bamboo.logger.ErrorHandler;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.utils.ResourceResolver;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.atlassian.bamboo.v2.build.agent.capability.DefaultAgentCapabilityManager;
import com.atlassian.bamboo.v2.build.agent.capability.DefaultAgentCapabilityManagerImpl;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElasticImageConfigurationManagerImpl
implements ElasticImageConfigurationManager {
    private static final Logger log = Logger.getLogger(ElasticImageConfigurationManagerImpl.class);
    private final ElasticImageConfigurationDao elasticImageConfigurationDao;
    private final ResourceResolver resourceResolver;
    private final ElasticImageConfigurationAccessor elasticImageConfigurationAccessor;
    private final ElasticInstanceScheduleManager elasticInstanceScheduleManager;
    private final AgentAssignmentService agentAssignmentService;
    private final EventPublisher eventPublisher;

    public ElasticImageConfigurationManagerImpl(ElasticImageConfigurationDao elasticImageConfigurationDao, ResourceResolver resourceResolver, ElasticImageConfigurationAccessor elasticImageConfigurationAccessor, ElasticInstanceScheduleManager elasticInstanceScheduleManager, AgentAssignmentService agentAssignmentService, EventPublisher eventPublisher) {
        this.elasticInstanceScheduleManager = elasticInstanceScheduleManager;
        this.elasticImageConfigurationAccessor = elasticImageConfigurationAccessor;
        this.elasticImageConfigurationDao = elasticImageConfigurationDao;
        this.resourceResolver = resourceResolver;
        this.agentAssignmentService = agentAssignmentService;
        this.eventPublisher = eventPublisher;
    }

    @Nullable
    public ElasticImageConfiguration getElasticImageConfigurationById(long configurationId) {
        return this.elasticImageConfigurationAccessor.getElasticImageConfigurationById(configurationId);
    }

    @NotNull
    public List<ElasticImageConfiguration> getElasticImageConfigurationsByName(@NotNull String configurationName, @NotNull AwsSupportConstants.Region region) {
        return this.elasticImageConfigurationAccessor.getElasticImageConfigurationsByName(configurationName, region);
    }

    @NotNull
    public List<ElasticImageConfiguration> getElasticImageConfigurationsShippedWithBamboo() {
        return this.elasticImageConfigurationAccessor.getElasticImageConfigurationsShippedWithBamboo();
    }

    @NotNull
    public List<ElasticImageConfiguration> getAllElasticImageConfigurations() {
        return this.elasticImageConfigurationAccessor.getAllElasticImageConfigurations();
    }

    @NotNull
    public List<ElasticImageConfiguration> getAllElasticImageConfigurationsForCurrentRegion() {
        return this.elasticImageConfigurationAccessor.getAllElasticImageConfigurationsForCurrentRegion();
    }

    public void saveElasticImageConfiguration(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        boolean creation = elasticImageConfiguration.getId() <= 0L;
        Collection azs = elasticImageConfiguration.getAvailabilityZones();
        if (Iterables.size((Iterable)azs) == 1 && "bamboo-default-availability-zone".equals(Iterables.getOnlyElement((Iterable)azs))) {
            elasticImageConfiguration.setAvailabilityZones(Collections.emptyList());
        }
        this.elasticImageConfigurationDao.save(elasticImageConfiguration);
        this.eventPublisher.publish((Object)(creation ? new ElasticImageConfigurationCreatedEvent(this, elasticImageConfiguration.getId()) : new ElasticImageConfigurationUpdatedEvent(this, elasticImageConfiguration.getId())));
    }

    public int getElasticAgentCountForImageConfiguration(long id) {
        return this.elasticImageConfigurationDao.getElasticAgentCountForImageConfigurationId(id);
    }

    public int getBuildsCountForImageConfiguration(long id) {
        return this.elasticImageConfigurationDao.getBuildCountForImageConfigurationId(id);
    }

    public void removeElasticImageConfiguration(@NotNull ElasticImageConfiguration elasticImageConfiguration) throws AWSException {
        List agents = this.elasticImageConfigurationDao.getElasticAgentsForImageConfigurationId(elasticImageConfiguration.getId());
        for (ElasticAgentDefinition agent : agents) {
            try {
                ((AgentManager)ComponentAccessor.AGENT_MANAGER.get()).removeAgent(agent.getId());
            }
            catch (TimeoutException e) {
                throw new AWSException("Failed to delete elastic image configuration, could not delete associated agent.", (Throwable)e);
            }
        }
        this.elasticInstanceScheduleManager.getElasticInstanceSchedules(elasticImageConfiguration).forEach(arg_0 -> ((ElasticInstanceScheduleManager)this.elasticInstanceScheduleManager).removeElasticInstanceSchedule(arg_0));
        this.agentAssignmentService.deleteExecutableAssignments((Iterable)this.agentAssignmentService.getAgentAssignments().forExecutors(AgentAssignmentServiceHelper.asExecutors((ElasticImageConfiguration)elasticImageConfiguration)));
        this.elasticImageConfigurationDao.remove(elasticImageConfiguration);
        this.eventPublisher.publish((Object)new ElasticImageConfigurationRemovedEvent(this, elasticImageConfiguration.getId()));
    }

    public void disableElasticImageSchedules(@NotNull ElasticImageConfiguration elasticImageConfiguration) {
        for (ElasticInstanceSchedule schedule : this.elasticInstanceScheduleManager.getElasticInstanceSchedules(elasticImageConfiguration)) {
            schedule.setEnabled(false);
            this.elasticInstanceScheduleManager.saveElasticInstanceSchedule(schedule);
        }
    }

    public void updateDefaultElasticImageConfiguration() throws Exception {
        log.info((Object)"Checking if stock EC2 images need updating...");
        ImageData defaultElasticImageDataFromEnvOrArtifact = this.getDefaultElasticImageData();
        if (defaultElasticImageDataFromEnvOrArtifact == null || defaultElasticImageDataFromEnvOrArtifact.getImageDefinitions().isEmpty()) {
            String message = "Bamboo could not find any stock elastic images";
            log.error((Object)"Bamboo could not find any stock elastic images");
            throw new Exception("Bamboo could not find any stock elastic images");
        }
        Set regionsWithImage = this.elasticImageConfigurationDao.getAll().stream().map(ElasticImageConfiguration::getRegion).collect(Collectors.toSet());
        for (ImageData.ImageDefinition imageDefinition : defaultElasticImageDataFromEnvOrArtifact.getImageDefinitions()) {
            try {
                boolean regionAlreadyHasImages = regionsWithImage.contains(imageDefinition.getRegion());
                this.updateOrCreateImageData(imageDefinition, regionAlreadyHasImages);
            }
            catch (RuntimeException e) {
                log.error((Object)String.format("Unable to update configuration of elastic image %s", imageDefinition.getImageId()), (Throwable)e);
                ErrorHandler errorHandler = (ErrorHandler)ComponentAccessor.ERROR_HANDLER.get();
                errorHandler.recordElasticError(e.getMessage(), null, (Throwable)e, null);
            }
        }
        log.info((Object)"EC2 images updated.");
    }

    private void updateOrCreateImageData(ImageData.ImageDefinition newStockImage, boolean regionAlreadyHasImages) {
        Predicate<ElasticImageConfiguration> isSameOs = existingImage -> {
            String osName = (String)StringUtils.defaultIfBlank((CharSequence)existingImage.getOsName(), (CharSequence)"Amazon Linux");
            return newStockImage.getOsName().equals(osName);
        };
        List matchingStockImages = this.elasticImageConfigurationDao.getImages(newStockImage.getRegion(), newStockImage.getRootDeviceType(), newStockImage.getImageArchitecture(), newStockImage.getImagePlatform(), Boolean.valueOf(true)).stream().filter(isSameOs).filter(configuration -> configuration.getVirtualisationType() == newStockImage.getVirtualisation()).collect(Collectors.toList());
        if (matchingStockImages.size() > 1) {
            Iterable imageIds = Iterables.transform(matchingStockImages, ElasticImageConfiguration::getAmiId);
            String format = String.format("Failed on updating stock images; expected 0 or 1, got %d stock images (%s) for %s - %s - %s on region %s. ", matchingStockImages.size(), Joiner.on((String)",").join(imageIds), newStockImage.getImagePlatform(), newStockImage.getImageArchitecture(), newStockImage.getRootDeviceType(), newStockImage.getRegion());
            throw new IllegalArgumentException(format);
        }
        ElasticImageConfiguration existingConfiguration = (ElasticImageConfiguration)Iterables.getOnlyElement(matchingStockImages, null);
        if (existingConfiguration == null) {
            this.createNewConfiguration(newStockImage, regionAlreadyHasImages);
        } else {
            this.updateExistingConfiguration(existingConfiguration, newStockImage);
        }
    }

    private void updateExistingConfiguration(ElasticImageConfiguration stockConfiguration, ImageData.ImageDefinition newStockImage) {
        String idOfOldStockImage = stockConfiguration.getAmiId();
        if (idOfOldStockImage.equals(newStockImage.getImageId())) {
            log.debug((Object)("No changes for image " + idOfOldStockImage));
            return;
        }
        log.info((Object)("Stock image " + idOfOldStockImage + " has been updated, updating all configuration basing on that image to " + newStockImage.getImageId()));
        List otherConfigsWithTheSameId = this.elasticImageConfigurationDao.getElasticImageConfigurationByAmi(idOfOldStockImage);
        for (ElasticImageConfiguration imageConfig : otherConfigsWithTheSameId) {
            imageConfig.setAmiId(newStockImage.getImageId());
            imageConfig.setOsName(newStockImage.getOsName());
            this.elasticImageConfigurationDao.save(imageConfig);
        }
    }

    private void createNewConfiguration(ImageData.ImageDefinition newStockImage, boolean regionAlreadyHasImages) {
        String configurationName = ElasticImageConfigurationHelper.getStockImageName(newStockImage);
        log.info((Object)("Creating image configuration: " + configurationName));
        ElasticImageConfigurationImpl stockImageToSave = new ElasticImageConfigurationImpl();
        stockImageToSave.setAmiId(newStockImage.getImageId());
        stockImageToSave.setArchitecture(newStockImage.getImageArchitecture());
        stockImageToSave.setPlatform(newStockImage.getImagePlatform());
        stockImageToSave.setProduct(newStockImage.getImagePlatform() == AwsSupportConstants.Platform.windows ? "Windows" : "Linux/UNIX");
        stockImageToSave.setConfigurationDescription("Elastic Image Configuration shipped with Bamboo");
        stockImageToSave.setConfigurationName(configurationName);
        EC2InstanceType instanceType = newStockImage.getImageArchitecture() == AwsSupportConstants.Architecture.i386 ? ElasticInstanceManager.DEFAULT_INSTANCE_TYPE_32 : ElasticInstanceManager.DEFAULT_INSTANCE_TYPE_64;
        stockImageToSave.setInstanceTypes(Collections.singleton(instanceType));
        stockImageToSave.setRegion(newStockImage.getRegion());
        stockImageToSave.setRootDeviceType(newStockImage.getRootDeviceType());
        stockImageToSave.setPerSecondBillingEnabled(true);
        stockImageToSave.setVirtualisationType(newStockImage.getVirtualisation());
        stockImageToSave.setShippedWithBamboo(true);
        stockImageToSave.setOsName(newStockImage.getOsName());
        stockImageToSave.setImageFilesVersion("3.0");
        boolean isDisabled = regionAlreadyHasImages || newStockImage.getVirtualisation() == AwsSupportConstants.Virtualisation.PV;
        stockImageToSave.setDisabled(isDisabled);
        this.populateDefaultCapabilitySet((CapabilitySet)stockImageToSave.getCapabilitySet(), stockImageToSave);
        this.elasticImageConfigurationDao.save((ElasticImageConfiguration)stockImageToSave);
    }

    public void populateDefaultCapabilitySet(CapabilitySet capabilitySet, ElasticImageConfiguration imageConfiguration) {
        DefaultAgentCapabilityManager defaultAgentCapabilityManager = this.getDefaultCapabilityManager(imageConfiguration.getPlatform(), imageConfiguration.getConfigurationName(), imageConfiguration.getArchitecture());
        if (defaultAgentCapabilityManager.isDefaultConfigurationAvailable()) {
            capabilitySet.getCapabilities().clear();
            defaultAgentCapabilityManager.addDefaultCapabilitiesToCapabilitySet(capabilitySet);
        } else {
            log.error((Object)"Image capabilities file elastic-image-capabilities.properties can't be found or is empty.");
        }
    }

    private DefaultAgentCapabilityManager getDefaultCapabilityManager(AwsSupportConstants.Platform platform, String name, AwsSupportConstants.Architecture architecture) {
        String capabilitiesFile = platform == AwsSupportConstants.Platform.windows ? "elastic-image-capabilities-windows.properties" : "elastic-image-capabilities.properties";
        return new DefaultAgentCapabilityManagerImpl(capabilitiesFile, this.resourceResolver);
    }

    @Nullable
    private ImageData getDefaultElasticImageData() {
        ImageData shippedElasticImageData = null;
        try {
            shippedElasticImageData = ElasticConfigurationImpl.getShippedElasticImageData();
        }
        catch (IOException e) {
            log.warn((Object)"Failed to retrieve default elastic image id", (Throwable)e);
        }
        String imageId = SystemProperty.ELASTIC_IMAGE_AMI_ID.getValue();
        if (imageId != null) {
            if (shippedElasticImageData == null) {
                shippedElasticImageData = new ImageData();
            } else {
                shippedElasticImageData.getImageDefinitions().clear();
            }
            return shippedElasticImageData.add(new ImageData.ImageDefinition(Regions.US_EAST_1, AwsSupportConstants.RootDeviceType.S3, AwsSupportConstants.Architecture.i386, AwsSupportConstants.Platform.linux, AwsSupportConstants.Virtualisation.UNKNOWN, "Amazon Linux", imageId));
        }
        return shippedElasticImageData;
    }
}

