/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.analytics;

import com.atlassian.bamboo.analytics.MauService;
import com.atlassian.bamboo.deployments.events.DeploymentTriggeredEvent;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.events.BuildQueuedEvent;
import com.atlassian.event.api.EventListener;

public class MauBuildDeployEventListener {
    private final MauService mauService;

    public MauBuildDeployEventListener(MauService mauService) {
        this.mauService = mauService;
    }

    @EventListener
    public void onBuildQueued(BuildQueuedEvent buildQueuedEvent) {
        BuildContext context = buildQueuedEvent.getContext();
        if (context != null) {
            this.mauService.processActivityForBuild(context);
        }
    }

    @EventListener
    public void onDeploymentTriggered(DeploymentTriggeredEvent deploymentTriggeredEvent) {
        DeploymentContext context = deploymentTriggeredEvent.getContext();
        if (context != null) {
            this.mauService.processActivityForDeployment(context);
        }
    }
}

