/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.analytics;

import com.atlassian.analytics.api.events.MauEvent;
import com.atlassian.bamboo.analytics.MauService;
import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.user.BambooRemoteUserUtils;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.v2.build.BuildChanges;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.trigger.CodeChangedTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ManualBuildTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.ScheduledTriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class MauServiceImpl
implements MauService {
    private static final Duration EVENT_PUBLISH_INTERVAL = Duration.ofHours(12L);
    private static final String WEB_ACTIVITY = "web";
    private static final String BUILD_ACTIVITY = "build";
    private static final String DEPLOY_ACTIVITY = "deploy";
    private static final Logger log = Logger.getLogger(MauServiceImpl.class);
    private EventPublisher eventPublisher;
    private BambooUserManager bambooUserManager;
    private AuthorDao authorDao;
    private final ConcurrentMap<String, Long> lastSeenCache;
    private long eventPublishIntervalMilliseconds;

    @Inject
    public MauServiceImpl(EventPublisher eventPublisher, BambooUserManager bambooUserManager, AuthorDao authorDao) {
        this.eventPublisher = eventPublisher;
        this.bambooUserManager = bambooUserManager;
        this.authorDao = authorDao;
        this.lastSeenCache = new ConcurrentHashMap<String, Long>();
        this.eventPublishIntervalMilliseconds = EVENT_PUBLISH_INTERVAL.toMillis();
    }

    @Override
    public void recordWebActivity(HttpServletRequest request) {
        this.recordActivity(BambooRemoteUserUtils.getRemoteUsername(request), WEB_ACTIVITY);
    }

    @Override
    public void processActivityForBuild(BuildContext context) {
        TriggerReason triggerReason = context.getTriggerReason();
        if (triggerReason != null) {
            this.processActivityForBuild(context, triggerReason);
        }
    }

    private void processActivityForBuild(BuildContext context, TriggerReason triggerReason) {
        String username;
        if (triggerReason instanceof ManualBuildTriggerReason) {
            this.recordActivity(((ManualBuildTriggerReason)triggerReason).getUserName(), BUILD_ACTIVITY);
        } else if (triggerReason instanceof CodeChangedTriggerReason) {
            List<String> linkedUserNames = this.getLinkedUserNamesFromBuildChanges(context.getBuildChanges());
            for (String linkedUserName : linkedUserNames) {
                this.recordActivity(linkedUserName, BUILD_ACTIVITY);
            }
        } else if (triggerReason instanceof ScheduledTriggerReason && (username = ((ScheduledTriggerReason)triggerReason).getUserScheduledBy()) != null) {
            this.recordActivity(username, BUILD_ACTIVITY);
        }
    }

    @NotNull
    private List<String> getLinkedUserNamesFromBuildChanges(BuildChanges changes) {
        ArrayList<String> linkedUserNames = new ArrayList<String>();
        Iterable repoChanges = changes.getRepositoryChanges();
        if (repoChanges != null) {
            for (BuildRepositoryChanges repoChange : repoChanges) {
                List commits = repoChange.getChanges();
                for (CommitContext commit : commits) {
                    ExtendedAuthor author;
                    AuthorContext commitAuthor = commit.getAuthorContext();
                    if (commitAuthor == null || (author = this.authorDao.getAuthorByName(commitAuthor.getName())) == null || author.getLinkedUserName() == null) continue;
                    linkedUserNames.add(author.getLinkedUserName());
                }
            }
        }
        return linkedUserNames;
    }

    @Override
    public void processActivityForDeployment(DeploymentContext context) {
        TriggerReason triggerReason = context.getTriggerReason();
        if (triggerReason != null) {
            this.processActivityForDeployment(triggerReason);
        }
    }

    private void processActivityForDeployment(TriggerReason triggerReason) {
        String username;
        if (triggerReason instanceof ManualBuildTriggerReason) {
            this.recordActivity(((ManualBuildTriggerReason)triggerReason).getUserName(), DEPLOY_ACTIVITY);
        } else if (triggerReason instanceof ScheduledTriggerReason && (username = ((ScheduledTriggerReason)triggerReason).getUserScheduledBy()) != null) {
            this.recordActivity(username, DEPLOY_ACTIVITY);
        }
    }

    private void recordActivity(String username, String category) {
        try {
            if (StringUtils.isNotBlank((CharSequence)username)) {
                long lastSentTime = Optional.ofNullable(this.lastSeenCache.get(username)).orElse(0L);
                long currentTime = System.currentTimeMillis();
                if (currentTime > lastSentTime + this.eventPublishIntervalMilliseconds) {
                    String email;
                    this.lastSeenCache.put(username, currentTime);
                    User user = this.bambooUserManager.getUser(username);
                    if (user != null && StringUtils.isNotBlank((CharSequence)(email = user.getEmail()))) {
                        this.eventPublisher.publish((Object)MauEvent.withEmail((String)email));
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug((Object)("Error while recording MAU activity for user '" + username + "'"), (Throwable)ex);
        }
    }

    @Override
    @VisibleForTesting
    public void clearLastSeenCache() {
        this.lastSeenCache.clear();
    }
}

