/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.applinks;

import com.atlassian.bamboo.applinks.ImpersonationService;
import com.atlassian.bamboo.security.ImpersonationHelper;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooRunnables;
import java.util.concurrent.Callable;
import org.acegisecurity.Authentication;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImpersonationServiceImpl
implements ImpersonationService {
    private static final Logger log = Logger.getLogger(ImpersonationServiceImpl.class);
    public static final String USER_TOKEN_KEY = "USER_TOKEN_KEY";
    private final BambooUserManager bambooUserManager;

    public ImpersonationServiceImpl(BambooUserManager bambooUserManager) {
        this.bambooUserManager = bambooUserManager;
    }

    @NotNull
    public <V> Callable<V> runAsUser(@NotNull String username, @NotNull Callable<V> callable) {
        BambooUser ud = this.bambooUserManager.loadUserByUsername(username);
        if (ud == null) {
            throw new IllegalArgumentException("username '" + username + "' does not exist. Cannot impersonate this user.");
        }
        return this.runWithUserDetails((UserDetails)ud, callable);
    }

    @NotNull
    public <V> Callable<V> runWithOptionalUserImpersonation(@Nullable String username, @NotNull Callable<V> callable) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return callable;
        }
        BambooUser ud = this.bambooUserManager.loadUserByUsername(username);
        if (ud == null) {
            return callable;
        }
        return this.runWithUserDetails((UserDetails)ud, callable);
    }

    private <V> Callable<V> runWithUserDetails(UserDetails ud, Callable<V> callable) {
        PrincipalAcegiUserToken auth = new PrincipalAcegiUserToken(USER_TOKEN_KEY, ud.getUsername(), ud.getPassword(), ud.getAuthorities(), (Object)ud);
        return this.runWithAuthenticationImpersonation((Authentication)auth, callable);
    }

    @NotNull
    public <V> Callable<V> runWithAuthenticationImpersonation(final @NotNull Authentication authentication, final @NotNull Callable<V> delegate) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                BambooRunnables.BambooRunnableFromCallable runnable = BambooRunnables.asBambooRunnable((Callable)delegate);
                ImpersonationHelper.runWith((Authentication)authentication, (BambooRunnables.ThrowingX)runnable);
                return runnable.get();
            }
        };
    }

    public void runWith(@NotNull Authentication authentication, @NotNull BambooRunnables.NotThrowing notThrowing) {
        ImpersonationHelper.runWith((Authentication)authentication, (BambooRunnables.ThrowingX)notThrowing);
    }
}

