/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.applinks;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.applinks.api.application.stash.StashProjectEntityType;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.bamboo.applinks.StashApplinksService;
import com.atlassian.bamboo.project.Project;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.net.URI;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StashApplinksServiceImpl
implements StashApplinksService {
    private static final Logger log = Logger.getLogger(StashApplinksServiceImpl.class);
    private final MutatingApplicationLinkService applinkApplicationLink;
    private final AuthenticationConfigurationManager applinkAuthenticationConfigurationManager;
    private final EntityLinkService applinkEntityLink;
    private final TypeAccessor applinkTypeAccessor;

    public StashApplinksServiceImpl(MutatingApplicationLinkService applinkApplicationLink, AuthenticationConfigurationManager applinkAuthenticationConfigurationManager, EntityLinkService applinkEntityLink, TypeAccessor applinkTypeAccessor) {
        this.applinkApplicationLink = applinkApplicationLink;
        this.applinkAuthenticationConfigurationManager = applinkAuthenticationConfigurationManager;
        this.applinkEntityLink = applinkEntityLink;
        this.applinkTypeAccessor = applinkTypeAccessor;
    }

    @NotNull
    public ApplicationLink createStashApplinkWithBasicAuthentication(@NotNull String name, @NotNull URI serverUrl, @NotNull String username, @NotNull String password) throws ManifestNotFoundException, AuthenticationConfigurationException {
        ApplicationType applicationType = this.getStashApplicationType();
        ApplicationLinkDetails details = ApplicationLinkDetails.builder().name(name).displayUrl(serverUrl).rpcUrl(serverUrl).build();
        ApplicationLink applicationLink = this.applinkApplicationLink.createApplicationLink(applicationType, details);
        ImmutableMap config = ImmutableMap.of((Object)"username", (Object)username, (Object)"password", (Object)password);
        this.applinkAuthenticationConfigurationManager.registerProvider(applicationLink.getId(), BasicAuthenticationProvider.class, (Map)config);
        return applicationLink;
    }

    public ApplicationType getStashApplicationType() {
        return this.applinkTypeAccessor.getApplicationType(StashApplicationType.class);
    }

    public EntityType getStashProjectEntityType() {
        return this.applinkTypeAccessor.getEntityType(StashProjectEntityType.class);
    }

    @NotNull
    public Iterable<ApplicationLink> getStashApplicationLinks() {
        return this.getApplicationLinkOrdering().sortedCopy(this.applinkApplicationLink.getApplicationLinks(this.getStashApplicationType().getClass()));
    }

    public boolean hasStashApplicationLink() {
        return !Iterables.isEmpty(this.getStashApplicationLinks());
    }

    public Iterable<EntityLink> getStashEntityLinksForProject(@NotNull Project bambooProject) {
        return this.getEntityLinkOrdering().sortedCopy(this.applinkEntityLink.getEntityLinks((Object)bambooProject, this.getStashProjectEntityType().getClass()));
    }

    private Ordering<ApplicationLink> getApplicationLinkOrdering() {
        return new Ordering<ApplicationLink>(){

            public int compare(ApplicationLink left, ApplicationLink right) {
                if (left.isPrimary() == right.isPrimary()) {
                    return left.getName().compareTo(right.getName());
                }
                return left.isPrimary() ? -1 : 1;
            }
        };
    }

    private Ordering<EntityLink> getEntityLinkOrdering() {
        return new Ordering<EntityLink>(){

            public int compare(EntityLink left, EntityLink right) {
                if (left.isPrimary() == right.isPrimary()) {
                    return left.getName().compareTo(right.getName());
                }
                return left.isPrimary() ? -1 : 1;
            }
        };
    }
}

