/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.archive;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.archive.Archiver;
import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.archive.ZipArchiver;
import org.jetbrains.annotations.NotNull;

@Internal
public class ArchiverResolver {
    @NotNull
    public static Archiver getArchiver(@NotNull ArchiverType archiverType) {
        switch (archiverType) {
            case ZIP: {
                return new ZipArchiver();
            }
        }
        throw new IllegalArgumentException("Unknown archiver type: " + archiverType.name());
    }

    @NotNull
    public static String getDefaultArchiveExtension(@NotNull ArchiverType archiverType) {
        return (String)ArchiverResolver.getArchiver(archiverType).getArchiveFileExtensions().get(0);
    }
}

