/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.archive;

import com.atlassian.bamboo.archive.Archiver;
import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TVFS;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ZipArchiver
implements Archiver {
    private static final List<String> ARCHIVE_FILE_EXTENSIONS = Collections.singletonList("zip");

    ZipArchiver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compressFiles(@NotNull Iterable<File> sourceFiles, @NotNull File archiveFile, @Nullable File baseDirectory) throws IOException {
        TFile outputArchive = new TFile(archiveFile);
        outputArchive.mkdirs();
        try {
            for (File sourceFile : sourceFiles) {
                String filePath = this.getArchivePathForFile(sourceFile, baseDirectory);
                TFile archive = new TFile((File)outputArchive, filePath);
                TFile.cp_p((File)sourceFile, (File)archive);
            }
        }
        finally {
            TVFS.umount((TFile)outputArchive);
        }
    }

    public void extractArchive(@NotNull File archiveFile, @NotNull File destinationDirectory) throws IOException {
        TFile.cp_rp((File)new TFile(archiveFile), (File)destinationDirectory, (TArchiveDetector)TArchiveDetector.NULL, (TArchiveDetector)TArchiveDetector.NULL);
    }

    @NotNull
    public List<String> getArchiveFileExtensions() {
        return ARCHIVE_FILE_EXTENSIONS;
    }

    @NotNull
    private String getArchivePathForFile(@NotNull File sourceFile, @Nullable File baseDirectory) {
        if (baseDirectory == null) {
            return sourceFile.getName();
        }
        return baseDirectory.toURI().relativize(sourceFile.toURI()).getPath();
    }
}

