/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.artifact;

import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.plan.PlanResultKey;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ArtifactImpl
implements Artifact,
Serializable {
    private static final Logger log = Logger.getLogger(ArtifactImpl.class);
    private long id;
    private String label;
    private long persistedSize;
    private boolean isSharedArtifact;
    private boolean isGloballyStored;
    private String linkType = "system";
    private PlanResultKey planResultKey;
    private ArchiverType archiverType = ArchiverType.NONE;

    public ArtifactImpl(Artifact other) {
        this.id = other.getId();
        this.label = other.getLabel();
        this.planResultKey = other.getPlanResultKey();
        this.linkType = other.getLinkType();
        this.isSharedArtifact = other.isSharedArtifact();
        this.isGloballyStored = other.isGloballyStored();
        this.persistedSize = other.getSize();
        this.archiverType = other.getArchiverType();
    }

    public static ArtifactImpl globallyStoredCopyOf(Artifact other) {
        ArtifactImpl artifact = new ArtifactImpl(other);
        artifact.isGloballyStored = true;
        return artifact;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    public long getSize() {
        return this.persistedSize;
    }

    @NotNull
    public String getLinkType() {
        return this.linkType;
    }

    public boolean isSharedArtifact() {
        return this.isSharedArtifact;
    }

    public boolean isGloballyStored() {
        return this.isGloballyStored;
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    public long getId() {
        return this.id;
    }

    @NotNull
    public ArchiverType getArchiverType() {
        return this.archiverType;
    }
}

