/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.artifact;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.artifact.ArtifactPermissionService;
import com.atlassian.bamboo.deployments.projects.DeploymentProject;
import com.atlassian.bamboo.deployments.projects.service.DeploymentProjectService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.security.BambooPermissionManager;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.Permission;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactPermissionServiceImpl
implements ArtifactPermissionService {
    private static final Logger log = Logger.getLogger(ArtifactPermissionServiceImpl.class);
    private final CachedPlanManager cachedPlanManager;
    private final DeploymentProjectService deploymentProjectService;
    private final BambooPermissionManager bambooPermissionManager;

    public ArtifactPermissionServiceImpl(CachedPlanManager cachedPlanManager, DeploymentProjectService deploymentProjectService, BambooPermissionManager bambooPermissionManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.deploymentProjectService = deploymentProjectService;
        this.bambooPermissionManager = bambooPermissionManager;
    }

    @Override
    public boolean hasReadPermission(@NotNull Artifact artifact, @Nullable Authentication authentication) {
        PlanResultKey planResultKey = artifact.getPlanResultKey();
        PlanKey planKey = planResultKey.getPlanKey();
        PlanKey chainKey = PlanKeys.isJobKey((PlanKey)planKey) ? PlanKeys.getChainKeyIfJobKey((PlanKey)planKey) : planKey;
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(planKey);
        if (plan != null && this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)plan, authentication)) {
            return true;
        }
        for (DeploymentProject deploymentProject : this.deploymentProjectService.getDeploymentProjectsReferencingArtifact(artifact)) {
            if (!this.bambooPermissionManager.hasPermission((Permission)BambooPermission.READ, (Object)deploymentProject, authentication)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReadPermission(@NotNull Artifact artifact) {
        return this.hasReadPermission(artifact, null);
    }
}

