/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.artifact;

import com.atlassian.bamboo.archive.ArchiverType;
import com.atlassian.bamboo.artifact.MutableArtifact;
import com.atlassian.bamboo.hibernate.HibernateBambooEntityObject;
import com.atlassian.bamboo.plan.PlanResultKey;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Index;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;
import org.jetbrains.annotations.NotNull;

@NamedQueries(value={@NamedQuery(name="isArtifactReferencedByVersion", query="select count(vi.id)       from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi       where vi.artifact.id = :artifactId"), @NamedQuery(name="findVersionArtifactsByPlanKey", query="select a     from com.atlassian.bamboo.artifact.MutableArtifactImpl a     where a.isSharedArtifact = :sharedArtifact       and a.planResultKey.planKey = :planKey       and a.id in (select vi.artifact.id from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi)"), @NamedQuery(name="findOrphanedArtifacts", query="select a       from com.atlassian.bamboo.artifact.MutableArtifactImpl a       where not exists (select vi.artifact.id from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi where vi.artifact.id = a.id)       and not exists (select al.artifact.id from com.atlassian.bamboo.build.artifact.DefaultArtifactLink al where al.artifact.id = a.id)"), @NamedQuery(name="findOrphanedArtifactsByIds", query="select a       from com.atlassian.bamboo.artifact.MutableArtifactImpl a       where a.id in :artifactIds       and not exists (select vi.artifact.id from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi where vi.artifact.id = a.id)       and not exists (select al.artifact.id from com.atlassian.bamboo.build.artifact.DefaultArtifactLink al where al.artifact.id = a.id)"), @NamedQuery(name="findNonVersionArtifactsByPlanKey", query="select a     from com.atlassian.bamboo.artifact.MutableArtifactImpl a     where a.planResultKey.planKey = :planKey       and (            a.isGloballyStored = :globallyStored            or            a.id not in (select vi.artifact.id from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi)       )"), @NamedQuery(name="findNonVersionArtifactsByPlanResultKey", query="select a     from com.atlassian.bamboo.artifact.MutableArtifactImpl a     where a.planResultKey.planKey = :planKey       and a.planResultKey.buildNumber = :buildNumber       and (            a.isGloballyStored = :globallyStored            or            a.id not in (select vi.artifact.id from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi)       )"), @NamedQuery(name="findDeploymentProjectsReferencingArtifact", query="select distinct vi.deploymentVersion.deploymentProject         from com.atlassian.bamboo.deployments.versions.persistence.items.MutableArtifactDeploymentVersionItemImpl vi         where vi.artifact.id = :artifactId"), @NamedQuery(name="artifactStorageSizeByLinkType", query="select ma.linkType, sum(ma.persistedSize)         from com.atlassian.bamboo.artifact.MutableArtifactImpl ma         group by ma.linkType")})
@Entity
@Table(name="ARTIFACT", indexes={@Index(columnList="PLAN_KEY,BUILD_NUMBER", name="artifact_plan_key")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="ARTIFACT_ID"))
public class MutableArtifactImpl
extends HibernateBambooEntityObject
implements MutableArtifact {
    private static final Logger log = Logger.getLogger(MutableArtifactImpl.class);
    @Column(name="LABEL", nullable=false)
    private String label;
    @Column(name="ARTIFACT_SIZE")
    private Long persistedSize;
    @Column(name="CHAIN_ARTIFACT", nullable=false)
    private boolean isSharedArtifact;
    @Column(name="GLOBALLY_STORED", nullable=false)
    private boolean isGloballyStored;
    @Column(name="LINK_TYPE")
    private String linkType = "system";
    @Columns(columns={@Column(name="PLAN_KEY", nullable=false), @Column(name="BUILD_NUMBER", nullable=false)})
    @Type(type="com.atlassian.bamboo.plan.PlanResultKeyCompositeUserType")
    private PlanResultKey planResultKey;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="ARCHIVER_TYPE")
    private ArchiverType archiverType = ArchiverType.NONE;

    public MutableArtifactImpl() {
    }

    public MutableArtifactImpl(String label, PlanResultKey planResultKey, String linkType, boolean sharedArtifact) {
        this.label = label;
        this.planResultKey = planResultKey;
        this.linkType = linkType;
        this.isSharedArtifact = sharedArtifact;
    }

    public MutableArtifactImpl(String label, PlanResultKey planResultKey, String linkType, boolean sharedArtifact, Long persistedSize) {
        this(label, planResultKey, linkType, sharedArtifact);
        this.persistedSize = persistedSize;
    }

    @NotNull
    public String getLabel() {
        return this.label;
    }

    public long getSize() {
        if (this.persistedSize != null) {
            return this.persistedSize;
        }
        return -1L;
    }

    @NotNull
    public String getLinkType() {
        return this.linkType;
    }

    public boolean isSharedArtifact() {
        return this.isSharedArtifact;
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return this.planResultKey;
    }

    public boolean isGloballyStored() {
        return this.isGloballyStored;
    }

    @NotNull
    public ArchiverType getArchiverType() {
        return this.archiverType;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setSize(Long persistedSize) {
        this.persistedSize = persistedSize;
    }

    public void setSharedArtifact(boolean sharedArtifact) {
        this.isSharedArtifact = sharedArtifact;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }

    public void setPlanResultKey(PlanResultKey planResultKey) {
        this.planResultKey = planResultKey;
    }

    public void setGloballyStored(boolean isGloballyStored) {
        this.isGloballyStored = isGloballyStored;
    }

    public void setArchiverType(@NotNull ArchiverType archiverType) {
        this.archiverType = archiverType;
    }
}

