/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorData;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.util.BambooStringUtils;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AttributeOverride(name="id", column=@Column(name="AUTHOR_ID"))
public class AuthorDataImpl
extends BambooEntityObject
implements Serializable,
AuthorData {
    private static final int AUTHOR_NAME_MAX_LEN = 255;
    @Column(name="AUTHOR_NAME", unique=true, updatable=false)
    private String name;
    @Column(name="LINKED_USER_NAME")
    private String linkedUserName;
    @Column(name="AUTHOR_EMAIL")
    private String email;

    protected AuthorDataImpl() {
    }

    public AuthorDataImpl(@Nullable String name) {
        this.setName(name);
    }

    public AuthorDataImpl(@Nullable String name, @Nullable String linkedUserName) {
        this(name);
        this.linkedUserName = linkedUserName;
    }

    public AuthorDataImpl(@Nullable String name, @Nullable String linkedUserName, @Nullable String email) {
        this(name, linkedUserName);
        this.email = email;
    }

    public AuthorDataImpl(@NotNull AuthorContext author) {
        this(author.getName(), author.getLinkedUserName(), author.getEmail());
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = BambooStringUtils.truncateAndAddEllipsisToLengthInBytes((String)StringUtils.trim((String)name), (int)255);
    }

    @Nullable
    public String getLinkedUserName() {
        return this.linkedUserName;
    }

    public void setLinkedUserName(@Nullable String linkedUserName) {
        this.linkedUserName = linkedUserName;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public boolean equals(Object o) {
        if (!(o instanceof AuthorData)) {
            return false;
        }
        AuthorData rhs = (AuthorData)o;
        return Objects.equals(this.getName(), rhs.getName());
    }

    public int compareTo(AuthorContext otherAuthor) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)otherAuthor.getName()).toComparison();
    }
}

