/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.ChangeAuthor;
import com.atlassian.bamboo.index.AbstractDocumentHitCollector;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocument;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocumentFactory;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.jetbrains.annotations.NotNull;

public class AuthorDocumentCollector
extends AbstractDocumentHitCollector {
    private static final Logger log = Logger.getLogger(AuthorDocumentCollector.class);
    Map<String, ChangeAuthor> authors;
    BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory;

    public AuthorDocumentCollector(BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory, Map<String, ChangeAuthor> authors) {
        this.authors = authors;
        this.buildResultsSummaryDocumentFactory = buildResultsSummaryDocumentFactory;
    }

    public void collect(int docId) {
        try {
            Document doc = this.context.reader().document(docId);
            String[] names = doc.getValues("authors");
            if (names != null) {
                BuildResultsSummaryDocument brsDoc = this.buildResultsSummaryDocumentFactory.getBuildResultsSummary(doc);
                for (String name : names) {
                    ChangeAuthor author = this.authors.get(name);
                    if (author == null) {
                        author = new ChangeAuthor(name);
                        this.authors.put(name, author);
                    }
                    author.addTriggeredBuildResult((ResultsSummary)brsDoc);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    protected void collect(@NotNull Document document) {
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }
}

