/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.utils.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthorDuplicateNameHelper {
    private static final Logger log = Logger.getLogger(AuthorDuplicateNameHelper.class);
    private static final Pattern DUPLICATE_AUTHOR_NAME_MARKER_PATTERN = Pattern.compile("(\\d+);(\\d+)");

    public static String createNameMarkerPattern(long originalId, long duplicateId) {
        return Long.toString(originalId) + ";" + Long.toString(duplicateId);
    }

    @Nullable
    public static Pair<Long, Long> getAuthorIdFromNameMarkerPattern(@NotNull String authorName) {
        Matcher matcher = DUPLICATE_AUTHOR_NAME_MARKER_PATTERN.matcher(authorName);
        if (matcher.matches()) {
            Long originalId = Long.parseLong(matcher.group(1));
            Long duplicateId = Long.parseLong(matcher.group(2));
            return Pair.make((Object)originalId, (Object)duplicateId);
        }
        return null;
    }
}

