/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.AuthorContext;
import com.atlassian.bamboo.author.AuthorDataImpl;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.user.User;
import com.google.common.base.Supplier;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;

@Deprecated
@Entity
@Table(name="AUTHOR")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public class AuthorImpl
extends AuthorDataImpl
implements ExtendedAuthor {
    private FinalArrayList<ResultsSummary> breakages;
    private int numberOfBreakages = -1;
    private FinalArrayList<ResultsSummary> fixes;
    private int numberOfFixes = -1;
    private FinalArrayList<ResultsSummary> successfulBuilds;
    private int numberOfSuccessfulBuilds = -1;
    private FinalArrayList<ResultsSummary> failedBuilds;
    private int numberOfFailedBuilds = -1;
    private FinalArrayList<ResultsSummary> triggeredBuildResults;
    private int numberOfTriggeredBuildResults = -1;
    private static final Supplier<ExtendedAuthorManager> extendedAuthorManager = ComponentAccessor.BAMBOO_EXTENDED_USER_MANAGER;
    private static final Supplier<BambooUserManager> bambooUserManager = ComponentAccessor.BAMBOO_USER_MANAGER;
    private static final int MAX_RESULT_COUNT = 10;
    private transient LazyReference<String> fullNameRef = new FullNameLazyReference();

    public AuthorImpl() {
    }

    public AuthorImpl(String name) {
        super(name);
    }

    public AuthorImpl(String name, String linkedUserName) {
        super(name, linkedUserName);
    }

    public AuthorImpl(String name, String linkedUserName, String email) {
        super(name, linkedUserName, email);
    }

    public AuthorImpl(AuthorContext newAuthor) {
        super(newAuthor);
    }

    @NotNull
    public String getFullName() {
        return (String)this.fullNameRef.get();
    }

    public List<ResultsSummary> getBreakages() {
        if (this.breakages == null) {
            this.breakages = new FinalArrayList((Collection)((ExtendedAuthorManager)extendedAuthorManager.get()).findBuildResultsBrokenByAuthor((ExtendedAuthor)this, 10));
        }
        return this.breakages;
    }

    public List<ResultsSummary> getFixes() {
        if (this.fixes == null) {
            this.fixes = new FinalArrayList((Collection)((ExtendedAuthorManager)extendedAuthorManager.get()).findBuildResultsFixedByAuthor((ExtendedAuthor)this, 10));
        }
        return this.fixes;
    }

    public List<ResultsSummary> getSuccessfulBuilds() {
        if (this.successfulBuilds == null) {
            this.successfulBuilds = new FinalArrayList((Collection)((ExtendedAuthorManager)extendedAuthorManager.get()).findBuildResultsSuccessfulByAuthor((ExtendedAuthor)this, 10));
        }
        return this.successfulBuilds;
    }

    public List<ResultsSummary> getFailedBuilds() {
        if (this.failedBuilds == null) {
            this.failedBuilds = new FinalArrayList((Collection)((ExtendedAuthorManager)extendedAuthorManager.get()).findBuildResultsFailedByAuthor((ExtendedAuthor)this, 10));
        }
        return this.failedBuilds;
    }

    public List<ResultsSummary> getTriggeredBuildResults() {
        if (this.triggeredBuildResults == null) {
            this.triggeredBuildResults = new FinalArrayList((Collection)((ExtendedAuthorManager)extendedAuthorManager.get()).findBuildResultsTriggeredByAuthor((ExtendedAuthor)this, 10));
        }
        return this.triggeredBuildResults;
    }

    public List<ResultsSummary> getAllTriggeredBuildResults() {
        if (this.triggeredBuildResults == null) {
            this.triggeredBuildResults = new FinalArrayList((Collection)((ExtendedAuthorManager)extendedAuthorManager.get()).findBuildResultsTriggeredByAuthor((ExtendedAuthor)this, 0));
        }
        return this.triggeredBuildResults;
    }

    public int getNumberOfBreakages() {
        if (this.numberOfBreakages < 0) {
            this.numberOfBreakages = ((ExtendedAuthorManager)extendedAuthorManager.get()).findNumberOfBuildBrokenByAuthor((ExtendedAuthor)this);
        }
        return this.numberOfBreakages;
    }

    public int getNumberOfFixes() {
        if (this.numberOfFixes < 0) {
            this.numberOfFixes = ((ExtendedAuthorManager)extendedAuthorManager.get()).findNumberOfBuildFixedByAuthor((ExtendedAuthor)this);
        }
        return this.numberOfFixes;
    }

    public int getNumberOfFailedBuilds() {
        if (this.numberOfFailedBuilds < 0) {
            this.numberOfFailedBuilds = ((ExtendedAuthorManager)extendedAuthorManager.get()).findNumberOfFailedBuildsByAuthor((ExtendedAuthor)this);
        }
        return this.numberOfFailedBuilds;
    }

    public int getNumberOfSuccessfulBuilds() {
        if (this.numberOfSuccessfulBuilds < 0) {
            this.numberOfSuccessfulBuilds = ((ExtendedAuthorManager)extendedAuthorManager.get()).findNumberOfSuccessfulBuildsByAuthor((ExtendedAuthor)this);
        }
        return this.numberOfSuccessfulBuilds;
    }

    public int getNumberOfTriggeredBuilds() {
        if (this.numberOfTriggeredBuildResults < 0) {
            this.numberOfTriggeredBuildResults = ((ExtendedAuthorManager)extendedAuthorManager.get()).findNumberOfBuildsTriggeredByAuthor((ExtendedAuthor)this);
        }
        return this.numberOfTriggeredBuildResults;
    }

    protected Object readResolve() {
        this.fullNameRef = new FullNameLazyReference();
        return this;
    }

    private class FullNameLazyReference
    extends LazyReference<String> {
        private FullNameLazyReference() {
        }

        @NotNull
        protected String create() throws Exception {
            User user;
            if (AuthorImpl.this.getLinkedUserName() != null && (user = ((BambooUserManager)bambooUserManager.get()).getUser(AuthorImpl.this.getLinkedUserName())) != null) {
                return (String)StringUtils.defaultIfEmpty((CharSequence)user.getFullName(), (CharSequence)user.getName());
            }
            return StringUtils.defaultString((String)AuthorImpl.this.getName());
        }
    }
}

