/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorDao;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.user.BambooUser;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.fugue.Option;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.Query;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateAuthorManagerImpl
implements ExtendedAuthorManager {
    private static final Logger log = Logger.getLogger(HibernateAuthorManagerImpl.class);
    private static final Pattern PATTERN_AUTHOR_EMAIL = Pattern.compile("(.*?)<(.*?@.*?)>");
    private final AuthorDao authorDao;
    @Inject
    private BambooUserManager bambooUserManager;

    public HibernateAuthorManagerImpl(AuthorDao authorDao) {
        this.authorDao = authorDao;
    }

    ExtendedAuthor createAndReturnAuthor(@NotNull Author newAuthor) {
        String trimmedAuthorName = newAuthor.getName().trim();
        ExtendedAuthor author = this.getExtendedAuthorByName(trimmedAuthorName);
        if (author != null) {
            throw new RuntimeException("Author '" + trimmedAuthorName + "' already exists.");
        }
        author = new AuthorImpl(trimmedAuthorName, null, newAuthor.getEmail());
        this.linkAuthorWithUser(author);
        return author;
    }

    public void createAndSaveAuthor(@NotNull Author author) {
        this.saveAuthor(this.createAndReturnAuthor(author));
    }

    private void linkAuthorWithUser(ExtendedAuthor author) {
        BambooUser user = this.bambooUserManager.getBambooUser(author.getName());
        if (user != null) {
            author.setLinkedUserName(user.getName());
        } else {
            this.linkAuthorByEmail(author);
        }
    }

    private Option<String> getEmailForAuthor(String authorName) {
        Matcher matcher = PATTERN_AUTHOR_EMAIL.matcher(authorName);
        if (matcher.matches()) {
            return Option.some((Object)matcher.group(2).trim());
        }
        return Option.none();
    }

    List<User> getUsersForEmail(String email) {
        if (StringUtils.isNotBlank((CharSequence)email)) {
            EmailTermQuery emailQuery = new EmailTermQuery(email, "starts_with");
            try {
                SearchResult results = this.bambooUserManager.findUsers((Query)emailQuery);
                if (results != null && results.pager() != null) {
                    return PagerUtils.toList((Pager)results.pager()).stream().filter(Objects::nonNull).filter(user -> email.equalsIgnoreCase(user.getEmail())).collect(Collectors.toList());
                }
            }
            catch (EntityException e) {
                log.error((Object)e.getMessage());
            }
        }
        return Collections.emptyList();
    }

    private void linkAuthorByEmail(ExtendedAuthor author) {
        for (String email : Iterables.concat(this.getEmailForAuthor(author.getName()), (Iterable)Option.option((Object)author.getEmail()))) {
            List<User> users = this.getUsersForEmail(email);
            if (users.isEmpty()) {
                log.debug((Object)("No users found with the email address: " + email));
                continue;
            }
            if (users.size() > 1) {
                log.debug((Object)("Multiple users found with the email address: " + email));
            }
            author.setLinkedUserName(users.get(0).getName());
            break;
        }
    }

    public Set getAllAuthors() {
        return new HashSet(this.authorDao.findAll());
    }

    public void unlinkAllAuthors() {
        Set authors = this.getAllAuthors();
        for (ExtendedAuthor author : authors) {
            author.setLinkedUserName(null);
            this.saveAuthor(author);
        }
    }

    public void relinkUnlinkedAuthors() {
        Set<ExtendedAuthor> authors = this.getAllUnlinkedAuthors();
        for (ExtendedAuthor author : authors) {
            this.linkAuthorWithUser(author);
            if (!StringUtils.isNotBlank((CharSequence)author.getLinkedUserName())) continue;
            this.saveAuthor(author);
        }
    }

    public Author getAuthorByName(String name) {
        return this.authorDao.getAuthorByName(name);
    }

    @NotNull
    public Set<ExtendedAuthor> getAllUnlinkedAuthors() {
        return this.authorDao.getAllUnlinkedAuthors();
    }

    public ExtendedAuthor getExtendedAuthorByName(String name) {
        return this.authorDao.getAuthorByName(name);
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsTriggeredByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.authorDao.getBuildResultsTriggeredByAuthor(author, maxResultCount);
    }

    public List<ResultsSummary> findRecentResultsTriggeredByAuthors(List<ExtendedAuthor> authors, int maxDays) {
        return this.authorDao.getRecentResultsTriggeredByAuthors(authors, maxDays);
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsFailedByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.authorDao.getBuildResultsFailedByAuthor(author, maxResultCount);
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsSuccessfulByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.authorDao.getBuildResultsSuccessfulByAuthor(author, maxResultCount);
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsBrokenByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.authorDao.getBuildResultsBrokenByAuthor(author, maxResultCount);
    }

    @NotNull
    public Collection<ResultsSummary> findLatestBuildBrokenByAuthorInEachPlan(ExtendedAuthor author) {
        List allBreakages = this.authorDao.getBuildResultsBrokenByAuthor(author, 0);
        HashMap<PlanKey, ResultsSummary> filteredBreakages = new HashMap<PlanKey, ResultsSummary>();
        for (ResultsSummary breakage : allBreakages) {
            ResultsSummary existingEntry = (ResultsSummary)filteredBreakages.get(breakage.getPlanKey());
            if (existingEntry != null && existingEntry.getBuildNumber() >= breakage.getBuildNumber()) continue;
            filteredBreakages.put(breakage.getPlanKey(), breakage);
        }
        return filteredBreakages.values();
    }

    @NotNull
    public List<ResultsSummary> findBuildResultsFixedByAuthor(ExtendedAuthor author, int maxResultCount) {
        return this.authorDao.getBuildResultsFixedByAuthor(author, maxResultCount);
    }

    public int findNumberOfBuildsTriggeredByAuthor(ExtendedAuthor author) {
        return this.authorDao.getNumberOfBuildsTriggeredByAuthor(author);
    }

    public int findNumberOfFailedBuildsByAuthor(ExtendedAuthor author) {
        return this.authorDao.getNumberOfFailedBuildsByAuthor(author);
    }

    public int findNumberOfSuccessfulBuildsByAuthor(ExtendedAuthor author) {
        return this.authorDao.getNumberOfSuccessfulBuildsByAuthor(author);
    }

    public int findNumberOfBuildFixedByAuthor(ExtendedAuthor author) {
        return this.authorDao.getNumberOfBuildFixedByAuthor(author);
    }

    public int findNumberOfBuildBrokenByAuthor(ExtendedAuthor author) {
        return this.authorDao.getNumberOfBuildBrokenByAuthor(author);
    }

    public ExtendedAuthor getAuthorById(long id) {
        return this.authorDao.findById(id);
    }

    @NotNull
    public List<ExtendedAuthor> getLinkedAuthorForUser(User user) {
        return this.authorDao.getLinkedAuthorsForUser(user);
    }

    @NotNull
    public List<ExtendedAuthor> getAvailableAuthors(@Nullable User user) {
        ArrayList<ExtendedAuthor> availableAuthors = new ArrayList<ExtendedAuthor>();
        if (user != null) {
            availableAuthors.addAll(this.getLinkedAuthorForUser(user));
        }
        availableAuthors.addAll(this.getAllUnlinkedAuthors());
        return Ordering.natural().sortedCopy(availableAuthors);
    }

    @NotNull
    public List<Author> findAuthorsByName(@NotNull String authorSearchString) {
        return this.authorDao.findAuthorsByName(authorSearchString);
    }

    @NotNull
    public List<Author> findAuthorsThatStartWith(@NotNull String authorSearchString, boolean unlinkedOnly) {
        return this.authorDao.findAuthorsThatStartWith(authorSearchString, unlinkedOnly);
    }

    @NotNull
    public List<Author> findAuthorsByUser(@NotNull String userSearchString) {
        return this.authorDao.findAuthorsByLinkedUser(userSearchString);
    }

    @NotNull
    public Set<Author> getAuthorsByResultSummary(@NotNull ResultsSummary resultsSummary) {
        return this.authorDao.getAuthorsByResultSummary(resultsSummary);
    }

    public void removeAuthor(ExtendedAuthor extendedAuthor) {
        this.authorDao.delete((BambooObject)extendedAuthor);
    }

    public void saveAuthor(ExtendedAuthor author) {
        this.authorDao.save((BambooObject)author);
    }
}

