/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorDocumentCollector;
import com.atlassian.bamboo.author.AuthorManager;
import com.atlassian.bamboo.author.ChangeAuthor;
import com.atlassian.bamboo.index.AbstractDocumentHitCollector;
import com.atlassian.bamboo.index.buildresult.BuildResultsSummaryDocumentFactory;
import com.atlassian.bamboo.resultsummary.search.IndexedBuildResultsSearcher;
import com.atlassian.bamboo.resultsummary.search.LuceneQueryBuilder;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.jetbrains.annotations.Nullable;

public class LuceneAuthorManagerImpl
implements AuthorManager {
    private static final Logger log = Logger.getLogger(LuceneAuthorManagerImpl.class);
    IndexedBuildResultsSearcher indexedBuildResultsSearcher;
    BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory;

    public Set<Author> getAllAuthors() {
        Term buildResultType = new Term("docType", "buildResult");
        TermQuery q = new TermQuery(buildResultType);
        Map<String, ChangeAuthor> results = this.getAuthorsByQuery((Query)q);
        return Sets.newHashSet(results.values());
    }

    public Set<Author> getAuthorsInBuild(long buildId) {
        Term buildResultTypeTerm = new Term("docType", "buildResult");
        BooleanQuery q = new BooleanQuery();
        q.add((Query)new TermQuery(buildResultTypeTerm), BooleanClause.Occur.MUST);
        q.add(LuceneQueryBuilder.numericQuery("buildId", buildId), BooleanClause.Occur.MUST);
        Map<String, ChangeAuthor> results = this.getAuthorsByQuery((Query)q);
        return Sets.newHashSet(results.values());
    }

    @Nullable
    public Author getAuthorByName(String name) {
        Term buildResultTypeTerm = new Term("docType", "buildResult");
        Term authorNameTerm = new Term("authors", name);
        BooleanQuery q = new BooleanQuery();
        q.add((Query)new TermQuery(buildResultTypeTerm), BooleanClause.Occur.MUST);
        q.add((Query)new TermQuery(authorNameTerm), BooleanClause.Occur.MUST);
        Map<String, ChangeAuthor> searchResults = this.getAuthorsByQuery((Query)q);
        if (searchResults != null && !searchResults.isEmpty()) {
            return (Author)searchResults.get(name);
        }
        return null;
    }

    private Map<String, ChangeAuthor> getAuthorsByQuery(Query q) {
        HashMap<String, ChangeAuthor> authors = new HashMap<String, ChangeAuthor>();
        AuthorDocumentCollector authorCollector = new AuthorDocumentCollector(this.getBuildResultsSummaryDocumentFactory(), authors);
        this.indexedBuildResultsSearcher.search(q, (AbstractDocumentHitCollector)authorCollector);
        return authors;
    }

    public BuildResultsSummaryDocumentFactory getBuildResultsSummaryDocumentFactory() {
        return this.buildResultsSummaryDocumentFactory;
    }

    public void setBuildResultsSummaryDocumentFactory(BuildResultsSummaryDocumentFactory buildResultsSummaryDocumentFactory) {
        this.buildResultsSummaryDocumentFactory = buildResultsSummaryDocumentFactory;
    }

    public IndexedBuildResultsSearcher getIndexedBuildResultsSearcher() {
        return this.indexedBuildResultsSearcher;
    }

    public void setIndexedBuildResultsSearcher(IndexedBuildResultsSearcher indexedBuildResultsSearcher) {
        this.indexedBuildResultsSearcher = indexedBuildResultsSearcher;
    }
}

