/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BandanaAccessVerifier;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;

public class BambooBandanaManager
implements BandanaManager {
    private final BandanaManager delegate;

    public BambooBandanaManager(BandanaManager delegate) {
        this.delegate = delegate;
    }

    @PostConstruct
    public void init() {
        this.delegate.init();
    }

    public Object getValue(BandanaContext context, String key) {
        BandanaAccessVerifier.checkReadAccess(key);
        return this.delegate.getValue(context, key);
    }

    public Object getValue(BandanaContext context, String key, boolean lookUp) {
        BandanaAccessVerifier.checkReadAccess(key);
        return this.delegate.getValue(context, key, lookUp);
    }

    public void setValue(BandanaContext context, String key, Object value) {
        BandanaAccessVerifier.checkWriteAccess(key);
        this.delegate.setValue(context, key, value);
    }

    @NotNull
    public Iterable<String> getKeys(BandanaContext context) {
        return BandanaAccessVerifier.filterOutInaccessibleKeys(this.delegate.getKeys(context));
    }

    public void removeValue(BandanaContext context, String key) {
        BandanaAccessVerifier.checkWriteAccess(key);
        this.delegate.removeValue(context, key);
    }
}

