/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaPersister;
import com.atlassian.bandana.impl.PersisterKey;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooCachingBandanaPersister
implements BandanaPersister {
    private final BandanaPersister delegate;
    private final LoadingCache<PersisterKey, Optional<Object>> cache;

    public BambooCachingBandanaPersister(final BandanaPersister delegate) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PersisterKey, Optional<Object>>(){

            public Optional<Object> load(@NotNull PersisterKey key) throws Exception {
                return Optional.fromNullable((Object)delegate.retrieve(key.getContext(), key.getKey()));
            }
        });
    }

    @Nullable
    public Object retrieve(BandanaContext context, String key) {
        return ((Optional)this.cache.getUnchecked((Object)BambooCachingBandanaPersister.newPersisterKey(context, key))).orNull();
    }

    @NotNull
    public Map<String, Object> retrieve(@NotNull BandanaContext context) {
        return this.delegate.retrieve(context);
    }

    @NotNull
    public Iterable<String> retrieveKeys(BandanaContext context) {
        return this.delegate.retrieveKeys(context);
    }

    public void store(BandanaContext context, String key, Object value) {
        PersisterKey pKey = BambooCachingBandanaPersister.newPersisterKey(context, key);
        this.delegate.store(context, key, value);
        this.cache.put((Object)pKey, (Object)Optional.fromNullable((Object)value));
    }

    public void flushCaches() {
        this.cache.invalidateAll();
    }

    public void remove(BandanaContext context) {
        this.delegate.remove(context);
        for (PersisterKey persisterKey : this.cache.asMap().keySet()) {
            if (!persisterKey.getContext().equals(context)) continue;
            this.cache.invalidate((Object)persisterKey);
        }
    }

    public void remove(BandanaContext context, String key) {
        this.delegate.remove(context, key);
        this.cache.invalidate((Object)BambooCachingBandanaPersister.newPersisterKey(context, key));
    }

    @NotNull
    private static PersisterKey newPersisterKey(@Nullable BandanaContext context, @Nullable String key) {
        return new PersisterKey(context, key);
    }
}

