/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.remoting.RemoteCallMarker;
import com.atlassian.bamboo.util.BambooIterablesUtils;
import com.atlassian.bamboo.utils.predicates.text.TextPredicates;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BandanaAccessVerifier {
    private static final String GENERAL_PURPOSE_RESTRICTED_PREFIX = "com.atlassian.restricted.";
    @VisibleForTesting
    static final String[] RESTRICTED_PREFIXES = new String[]{"com.atlassian.oauth.", "applinks.", "trustedapps.", "com.atlassian.restricted."};

    private BandanaAccessVerifier() {
    }

    static void checkWriteAccess(String key) {
        if (!RemoteCallMarker.isRemoteCall()) {
            return;
        }
        Preconditions.checkArgument((!StringUtils.startsWithAny((CharSequence)key, (CharSequence[])RESTRICTED_PREFIXES) ? 1 : 0) != 0, (Object)("Remote code cannot access: " + key));
    }

    static void checkReadAccess(String key) {
        if (!RemoteCallMarker.isRemoteCall()) {
            return;
        }
        Preconditions.checkArgument((!StringUtils.startsWithAny((CharSequence)key, (CharSequence[])RESTRICTED_PREFIXES) ? 1 : 0) != 0, (Object)("Remote code cannot access: " + key));
    }

    @NotNull
    public static Iterable<String> filterOutInaccessibleKeys(@Nullable Iterable<String> keys) {
        if (BambooIterablesUtils.isEmpty(keys)) {
            return Collections.emptyList();
        }
        if (!RemoteCallMarker.isRemoteCall()) {
            return keys;
        }
        return Iterables.filter(keys, (Predicate)Predicates.not(TextPredicates.startsWithAny((String[])RESTRICTED_PREFIXES)::test));
    }

    public static String createRestrictedKey(String s) {
        return GENERAL_PURPOSE_RESTRICTED_PREFIX + s;
    }
}

