/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.bamboo.hibernate.HibernateEntityObject;
import com.google.common.base.Preconditions;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BANDANA", indexes={@Index(columnList="BUILD_ID,BANDANA_KEY", name="band_key_idx")})
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
@AttributeOverride(name="id", column=@Column(name="BANDANA_ID"))
public class BandanaItem
extends HibernateEntityObject
implements Comparable<BandanaItem> {
    @Column(name="BUILD_ID")
    private long buildId = 0L;
    @Column(name="CHAIN_ID", nullable=false)
    @ColumnDefault(value="0")
    private long chainId = 0L;
    @Column(name="BANDANA_KEY")
    private String key;
    @Column(name="SERIALIZED_DATA")
    @Type(type="com.atlassian.hibernate.BucketClobStringType")
    private String serializedData;

    public BandanaItem() {
    }

    public BandanaItem(BambooBandanaContext bandanaContext, String key, String serializedData) {
        Preconditions.checkArgument((bandanaContext != null ? 1 : 0) != 0, (Object)"Context must not be null");
        this.buildId = bandanaContext.getPlanId();
        this.chainId = bandanaContext.getChainId();
        this.key = key;
        this.serializedData = serializedData;
    }

    public long getBuildId() {
        return this.buildId;
    }

    public void setBuildId(long buildId) {
        this.buildId = buildId;
    }

    public long getChainId() {
        return this.chainId;
    }

    public void setChainId(long chainId) {
        this.chainId = chainId;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getSerializedData() {
        return this.serializedData;
    }

    public void setSerializedData(String serializedData) {
        this.serializedData = serializedData;
    }

    public int hashCode() {
        return new HashCodeBuilder(149, 7).append(this.getBuildId()).append(this.getChainId()).append((Object)this.getKey()).append((Object)this.getSerializedData()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BandanaItem)) {
            return false;
        }
        BandanaItem rhs = (BandanaItem)o;
        return new EqualsBuilder().append(this.getBuildId(), rhs.getBuildId()).append(this.getChainId(), rhs.getChainId()).append((Object)this.getKey(), (Object)rhs.getKey()).append((Object)this.getSerializedData(), (Object)rhs.getSerializedData()).isEquals();
    }

    @Override
    public int compareTo(BandanaItem o) {
        return new CompareToBuilder().append((Object)this.getKey(), (Object)o.getKey()).append(this.getBuildId(), o.getBuildId()).append(this.getChainId(), o.getChainId()).append((Object)this.getSerializedData(), (Object)o.getSerializedData()).toComparison();
    }
}

